/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.taxa;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.TaxonomyImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;

public class MappedTaxonomy
extends TaxonomyImpl {
    private final Taxonomy base;
    private Map<String, SightingTaxon> mappingsToBase;
    private Map<String, String> baseToMapped;
    private Multimap<String, String> duplicateBaseToMapped;

    public MappedTaxonomy(Taxonomy base, String id, String name) {
        super(id, name, null, null);
        this.base = Preconditions.checkNotNull(base);
    }

    @Override
    public SightingTaxon toBaseSightingTaxon(String id) {
        SightingTaxon mapping = this.getMapping(id);
        if (mapping == null) {
            throw new IllegalArgumentException("There is no base mapping for " + id + ", should not have been allowed!");
        }
        return mapping;
    }

    public Taxonomy getBaseTaxonomy() {
        return this.base;
    }

    public synchronized void setMappings(MappingBuilder mappingBuilder) {
        this.mappingsToBase = mappingBuilder.mappingsToBase;
        this.baseToMapped = Maps.newHashMap();
        this.duplicateBaseToMapped = HashMultimap.create();
        block0: for (Map.Entry<String, Collection<String>> entry : mappingBuilder.baseToMapped.asMap().entrySet()) {
            String baseId = entry.getKey();
            Collection<String> mappedIds = entry.getValue();
            if (mappedIds.size() == 1) {
                this.baseToMapped.put(baseId, Iterables.getOnlyElement(mappedIds));
                continue;
            }
            ArrayList<Taxon> mappedTaxa = Lists.newArrayList();
            HashMultiset<Taxon.Type> typeCounts = HashMultiset.create();
            for (String mappedId : mappedIds) {
                Taxon mappedTaxon = this.getTaxon(mappedId);
                mappedTaxa.add(mappedTaxon);
                typeCounts.add(mappedTaxon.getType());
            }
            if (mappedTaxa.size() == 2 && typeCounts.count((Object)Taxon.Type.species) == 1 && typeCounts.count((Object)Taxon.Type.subspecies) == 1) {
                for (Taxon mappedTaxon : mappedTaxa) {
                    if (mappedTaxon.getType() != Taxon.Type.subspecies) continue;
                    this.baseToMapped.put(baseId, mappedTaxon.getId());
                    continue block0;
                }
                continue;
            }
            this.duplicateBaseToMapped.putAll(baseId, mappedIds);
        }
    }

    public void addMapping(Taxon taxon, SightingTaxon mapping) {
        Preconditions.checkArgument(taxon.getTaxonomy() == this);
        Preconditions.checkState(!this.mappingsToBase.containsKey(taxon.getId()));
        Preconditions.checkArgument(mapping.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES);
        this.mappingsToBase.put(taxon.getId(), mapping);
    }

    public SightingTaxon getExactMapping(Taxon taxon) {
        return this.mappingsToBase.get(taxon.getId());
    }

    public SightingTaxon getMapping(String id) {
        SightingTaxon mapping = this.mappingsToBase.get(id);
        if (mapping != null) {
            return mapping;
        }
        Taxon taxon = this.getTaxon(id);
        if (taxon == null) {
            throw new NullPointerException("Cannot map;  no taxon for \"" + id + "\"");
        }
        return this.getMapping(taxon);
    }

    public SightingTaxon getMapping(SightingTaxon sightingTaxon) {
        if (sightingTaxon.getType() == SightingTaxon.Type.SINGLE) {
            return this.getMapping(sightingTaxon.getId());
        }
        HashSet<String> baseIds = Sets.newHashSet();
        for (String mappedId : sightingTaxon.getIds()) {
            SightingTaxon baseTaxon = this.getMapping(mappedId);
            if (baseTaxon == null) continue;
            baseIds.addAll(baseTaxon.getIds());
        }
        if (baseIds.isEmpty()) {
            return null;
        }
        if (baseIds.size() == 1) {
            return SightingTaxons.newSightingTaxon((String)Iterables.getOnlyElement(baseIds));
        }
        if (sightingTaxon.getType() == SightingTaxon.Type.SP) {
            Taxon parentTaxon = this.base.getTaxon((String)baseIds.iterator().next()).getParent();
            if (parentTaxon.getType().compareTo(Taxon.Type.species) <= 0) {
                HashSet<String> allImmediateChildrenIds = Sets.newHashSet();
                for (Taxon child : parentTaxon.getContents()) {
                    allImmediateChildrenIds.add(child.getId());
                }
                if (allImmediateChildrenIds.equals(baseIds)) {
                    return SightingTaxons.newSightingTaxon(parentTaxon.getId());
                }
            }
            return SightingTaxons.newSpTaxon(baseIds);
        }
        Preconditions.checkState(sightingTaxon.getType() == SightingTaxon.Type.HYBRID);
        return SightingTaxons.newHybridTaxon(baseIds);
    }

    public SightingTaxon getMapping(Taxon taxon) {
        Taxon firstSpecies;
        SightingTaxon speciesMapping;
        SightingTaxon mapping = this.getExactMapping(taxon);
        if (mapping != null || taxon.getContents().isEmpty()) {
            return mapping;
        }
        if ((taxon.getType() == Taxon.Type.family || taxon.getType() == Taxon.Type.order) && (speciesMapping = this.getMapping(firstSpecies = TaxonUtils.getFirstChildOfType(taxon, Taxon.Type.species))) != null) {
            return speciesMapping.resolve(this.base).getParentOfAtLeastType(taxon.getType());
        }
        LinkedHashSet<String> baseTaxaIds = Sets.newLinkedHashSet();
        for (Taxon child : taxon.getContents()) {
            SightingTaxon childMapping = this.getExactMapping(child);
            if (childMapping == null || childMapping.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) continue;
            baseTaxaIds.addAll(childMapping.getIds());
        }
        if (baseTaxaIds.isEmpty()) {
            return null;
        }
        return SightingTaxons.newPossiblySpTaxon(baseTaxaIds);
    }

    public SightingTaxon getExactMappingFromBase(String id) {
        if (this.baseToMapped.containsKey(id)) {
            return SightingTaxons.newSightingTaxon(this.baseToMapped.get(id));
        }
        if (this.duplicateBaseToMapped.containsKey(id)) {
            return SightingTaxons.newSpTaxon(this.duplicateBaseToMapped.get(id));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SightingTaxon.Resolved resolveInto(SightingTaxon sightingTaxon) {
        SightingTaxon parent;
        if (sightingTaxon.getType() == SightingTaxon.Type.SINGLE) {
            return this.map(sightingTaxon.getId());
        }
        if (sightingTaxon.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
            SightingTaxon.Resolved resolved = this.map(sightingTaxon.getId());
            if (resolved == null) {
                return null;
            }
            for (Taxon resolvedTaxon : resolved.getTaxa()) {
                if (resolvedTaxon.getType() == Taxon.Type.subspecies) {
                    resolvedTaxon = resolvedTaxon.getParent();
                }
                for (Taxon child : resolvedTaxon.getContents()) {
                    if (!child.getName().equals(sightingTaxon.getSubIdentifier())) continue;
                    return SightingTaxons.newResolved(child);
                }
            }
            return resolved;
        }
        boolean first = true;
        Taxon.Type highestType = null;
        boolean multipleTypes = false;
        ArrayList<SightingTaxon.Resolved> resolveds = Lists.newArrayList();
        String singleParent = null;
        for (String string : sightingTaxon.getIds()) {
            SightingTaxon.Resolved resolved = Preconditions.checkNotNull(this.map(string), "No mapping from base taxon %s", (Object)string);
            resolveds.add(resolved);
            parent = resolved.getParent();
            if (first) {
                highestType = resolved.getLargestTaxonType();
                if (parent.getType() == SightingTaxon.Type.SINGLE) {
                    singleParent = parent.getId();
                }
                first = false;
                continue;
            }
            if (highestType != resolved.getLargestTaxonType()) {
                multipleTypes = true;
                if (resolved.getLargestTaxonType().compareTo(highestType) > 0) {
                    highestType = resolved.getLargestTaxonType();
                }
            }
            if (parent.getType() == SightingTaxon.Type.SINGLE) {
                String nextSingleParent = parent.getId();
                if (nextSingleParent.equals(singleParent)) continue;
                singleParent = null;
                continue;
            }
            singleParent = null;
        }
        HashSet<String> ids = Sets.newHashSet();
        if (multipleTypes) {
            for (SightingTaxon.Resolved resolved : resolveds) {
                parent = resolved.getParentOfAtLeastType(highestType);
                ids.addAll(parent.getIds());
            }
        } else {
            for (SightingTaxon.Resolved resolved : resolveds) {
                ids.addAll(resolved.getSightingTaxon().getIds());
            }
            if (singleParent != null) {
                boolean bl = false;
                Taxon singleParentTaxon = this.getTaxon(singleParent);
                if (singleParentTaxon.getType().compareTo(Taxon.Type.species) <= 0) {
                    void var8_17;
                    for (Taxon child : singleParentTaxon.getContents()) {
                        SightingTaxon mapping = this.getMapping(child);
                        if (mapping == null || mapping.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) continue;
                        ++var8_17;
                    }
                    if (var8_17 == ids.size()) {
                        return SightingTaxons.newResolved(singleParentTaxon);
                    }
                }
            }
        }
        if (ids.size() == 1) {
            return SightingTaxons.newSightingTaxon((String)Iterables.getOnlyElement(ids)).resolveInternal(this);
        }
        switch (sightingTaxon.getType()) {
            case SP: {
                return SightingTaxons.newSpTaxon(ids).resolveInternal(this);
            }
            case HYBRID: {
                return SightingTaxons.newHybridTaxon(ids).resolveInternal(this);
            }
        }
        throw new AssertionError();
    }

    private SightingTaxon.Resolved map(String id) {
        Taxon parentTaxon;
        SightingTaxon.Resolved resolvedParent;
        if (this.duplicateBaseToMapped.containsKey(id)) {
            SightingTaxon sps = SightingTaxons.newSpTaxon(this.duplicateBaseToMapped.get(id));
            return sps.resolveInternal(this);
        }
        String mapped = this.baseToMapped.get(id);
        if (mapped != null) {
            Taxon taxon = this.getTaxon(mapped);
            return SightingTaxons.newResolved(taxon);
        }
        Taxon baseTaxon = this.base.getTaxon(id);
        if (baseTaxon == null) {
            throw new IllegalStateException("Could not get a mapping for " + id);
        }
        if (baseTaxon.getType() == Taxon.Type.family || baseTaxon.getType() == Taxon.Type.order) {
            Taxon firstSpecies = TaxonUtils.getFirstChildOfType(baseTaxon, Taxon.Type.species);
            SightingTaxon.Resolved resolvedSpecies = this.map(firstSpecies.getId());
            if (resolvedSpecies != null) {
                return resolvedSpecies.getParentOfAtLeastType(baseTaxon.getType()).resolveInternal(this);
            }
            return null;
        }
        if (!baseTaxon.getContents().isEmpty()) {
            boolean allChildrenMappable = true;
            HashSet<String> mappedChildren = Sets.newHashSetWithExpectedSize(4);
            for (Taxon child : baseTaxon.getContents()) {
                if (this.duplicateBaseToMapped.containsKey(child.getId())) {
                    mappedChildren.addAll(this.duplicateBaseToMapped.get(child.getId()));
                    continue;
                }
                String mappedChild = this.baseToMapped.get(child.getId());
                if (mappedChild == null) {
                    if (baseTaxon.getType() == Taxon.Type.species && !child.getContents().isEmpty()) {
                        for (Taxon grandchild : child.getContents()) {
                            String mappedGrandchild = this.baseToMapped.get(grandchild.getId());
                            if (mappedGrandchild == null) continue;
                            mappedChildren.add(mappedGrandchild);
                        }
                        continue;
                    }
                    allChildrenMappable = false;
                    continue;
                }
                mappedChildren.add(mappedChild);
            }
            if (allChildrenMappable || mappedChildren.size() > 3) {
                if (mappedChildren.size() == 1) {
                    Taxon taxon = this.getTaxon((String)Iterables.getOnlyElement(mappedChildren));
                    return SightingTaxons.newResolved(taxon);
                }
                ImmutableSet.Builder taxaBuilder = ImmutableSet.builder();
                Taxon.Type highestType = null;
                boolean multipleTypes = false;
                for (String mappedChild : mappedChildren) {
                    Taxon taxon = this.getTaxon(mappedChild);
                    taxaBuilder.add(taxon);
                    if (highestType == null) {
                        highestType = taxon.getType();
                        continue;
                    }
                    if (highestType == taxon.getType()) continue;
                    if (!multipleTypes) {
                        // empty if block
                    }
                    multipleTypes = true;
                    if (taxon.getType().compareTo(highestType) <= 0) continue;
                    highestType = taxon.getType();
                }
                ImmutableCollection taxa = taxaBuilder.build();
                if (!multipleTypes && highestType == Taxon.Type.subspecies && taxa.size() > 3) {
                    multipleTypes = true;
                    highestType = Taxon.Type.species;
                }
                if (multipleTypes) {
                    taxaBuilder = ImmutableSet.builder();
                    for (Taxon taxon : taxa) {
                        taxaBuilder.add(TaxonUtils.getParentOfType(taxon, highestType));
                    }
                    taxa = taxaBuilder.build();
                }
                if (taxa.size() == 1) {
                    return SightingTaxons.newResolved((Taxon)Iterables.getOnlyElement(taxa));
                }
                return SightingTaxons.newSpResolved(taxa);
            }
        }
        if ((resolvedParent = this.resolveParent(parentTaxon = baseTaxon.getParent())) == null) {
            resolvedParent = this.resolveParent(parentTaxon.getParent());
        }
        if (resolvedParent == null && baseTaxon.getType().isLowerLevelThan(Taxon.Type.species)) {
            LinkedHashSet<Taxon> taxa = new LinkedHashSet<Taxon>();
            Taxon previous = TaxonUtils.getPreviousSibling(baseTaxon);
            while (previous != null) {
                SightingTaxon.Resolved mappedPrevious = this.map(previous.getId());
                if (mappedPrevious != null) {
                    taxa.addAll(mappedPrevious.getTaxa());
                    break;
                }
                previous = TaxonUtils.getPreviousSibling(previous);
            }
            Taxon next = TaxonUtils.getNextSibling(baseTaxon);
            while (next != null) {
                SightingTaxon.Resolved mappedNext = this.map(next.getId());
                if (mappedNext != null) {
                    taxa.addAll(mappedNext.getTaxa());
                    break;
                }
                next = TaxonUtils.getNextSibling(next);
            }
            if (!taxa.isEmpty()) {
                resolvedParent = SightingTaxons.newPossiblySpResolved(taxa).resolveParentOfType(Taxon.Type.species);
            }
        }
        return resolvedParent;
    }

    private SightingTaxon.Resolved resolveParent(Taxon baseTaxon) {
        if (this.duplicateBaseToMapped.containsKey(baseTaxon.getId())) {
            return SightingTaxons.newSpTaxon(this.duplicateBaseToMapped.get(baseTaxon.getId())).resolveInternal(this);
        }
        String mapped = this.baseToMapped.get(baseTaxon.getId());
        if (mapped != null) {
            Taxon taxon = this.getTaxon(mapped);
            return SightingTaxons.newResolved(taxon);
        }
        return null;
    }

    public static class MappingBuilder {
        private final Map<String, SightingTaxon> mappingsToBase = Maps.newHashMap();
        private final Multimap<String, String> baseToMapped = HashMultimap.create();

        public void registerTaxonMapping(Taxon taxon, SightingTaxon baseMapping) {
            SightingTaxon existing = this.mappingsToBase.put(taxon.getId(), baseMapping);
            Preconditions.checkState(existing == null, "Mapping already existed for " + taxon.getId());
            if (baseMapping.getType() != SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
                for (String id : baseMapping.getIds()) {
                    this.baseToMapped.put(id, taxon.getId());
                }
            }
        }

        public void removeTaxonMapping(Taxon taxon) {
            SightingTaxon removed = this.mappingsToBase.remove(taxon.getId());
            for (String id : removed.getIds()) {
                this.baseToMapped.remove(id, taxon.getId());
            }
        }

        public SightingTaxon getExactMapping(Taxon taxon) {
            return this.mappingsToBase.get(taxon.getId());
        }
    }
}

