/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.taxa;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharSource;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import java.io.IOException;

public class IocUpgradeLoader {
    private static final Splitter SP_SPLITTER = Splitter.on('/');
    private String id;
    private CharSource mappingSupplier;

    public IocUpgradeLoader(String id, CharSource mappingSupplier) {
        this.id = id;
        this.mappingSupplier = mappingSupplier;
    }

    public String getId() {
        return this.id;
    }

    public ImmutableSet<SightingTaxon> affectedSightingTaxa() throws IOException {
        ImmutableSet.Builder affectedSightingTaxa = ImmutableSet.builder();
        try (ImportLines lines = CsvImportLines.fromReader(this.mappingSupplier.openBufferedStream());){
            String[] line;
            while ((line = lines.nextLine()) != null) {
                SightingTaxon affectedTaxon = SightingTaxons.newPossiblySpTaxon(SP_SPLITTER.splitToList(line[0]));
                affectedSightingTaxa.add(affectedTaxon);
            }
        }
        return affectedSightingTaxa.build();
    }
}

