/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import com.scythebill.birdlist.model.util.Versions;
import java.util.Set;

public class UpgraderProcessing {
    private final ImmutableSet<Upgrader> upgraders;

    @Inject
    UpgraderProcessing(Set<Upgrader> upgraders) {
        this.upgraders = ImmutableSet.copyOf(upgraders);
    }

    public void upgradeReportSet(ReportSet reportSet) {
        for (Upgrader upgrader : this.upgraders) {
            if (reportSet.getLoadedVersion() != null && Versions.versionOrdering().compare(reportSet.getLoadedVersion(), upgrader.getVersion()) >= 0) continue;
            upgrader.upgrade(reportSet);
        }
    }
}

