/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;
import java.util.HashMap;

class UnitedKingdomCountries
implements Upgrader {
    private Provider<PredefinedLocations> predefinedLocationsProvider;

    @Inject
    UnitedKingdomCountries(Provider<PredefinedLocations> predefinedLocationsProvider) {
        this.predefinedLocationsProvider = predefinedLocationsProvider;
    }

    @Override
    public String getVersion() {
        return "9.3.1";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        PredefinedLocations predefinedLocations = this.predefinedLocationsProvider.get();
        LocationSet locations = reportSet.getLocations();
        Collection<Location> uks = locations.getLocationsByModelName("United Kingdom");
        if (uks.size() != 1) {
            return;
        }
        Location uk = Iterables.getOnlyElement(uks);
        ImmutableCollection<PredefinedLocations.PredefinedLocation> ukChildren = predefinedLocations.getPredefinedLocations(uk);
        Preconditions.checkState(!ukChildren.isEmpty());
        HashMap<PredefinedLocations.PredefinedLocation, Location> countriesOfTheUk = Maps.newHashMap();
        for (PredefinedLocations.PredefinedLocation predefinedLocation : ukChildren) {
            Location existingChild = uk.getContent(predefinedLocation.getName());
            if (existingChild != null) {
                countriesOfTheUk.put(predefinedLocation, existingChild);
                continue;
            }
            Location newChild = predefinedLocation.create(locations, uk);
            locations.ensureAdded(newChild);
            countriesOfTheUk.put(predefinedLocation, newChild);
        }
        for (Location location : ImmutableList.copyOf(uk.contents())) {
            if (location.isBuiltInLocation()) continue;
            for (Location countryOfTheUk : countriesOfTheUk.values()) {
                if (predefinedLocations.getPredefinedLocationChild(countryOfTheUk, location.getModelName()) == null) continue;
                location.reparent(countryOfTheUk);
            }
        }
    }
}

