/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.sighting.upgrades.OneTimeUpgrader;
import java.util.ArrayList;

class TaxonFixesForIoc101
implements OneTimeUpgrader {
    @Inject
    TaxonFixesForIoc101() {
    }

    @Override
    public String getName() {
        return "TaxonFixesForIoc101";
    }

    @Override
    public boolean upgrade(ReportSet reportSet) {
        ArrayList<Sighting> sightingsToRemove = new ArrayList<Sighting>();
        ArrayList<Sighting> sightingsToAdd = new ArrayList<Sighting>();
        for (Sighting sighting : reportSet.getSightings()) {
            if (!sighting.getTaxonomy().isBuiltIn() || !sighting.getTaxon().getType().equals((Object)SightingTaxon.Type.SP) || !sighting.getTaxon().getIds().contains("spAmazo1vin") || !sighting.getTaxon().getIds().contains("spAmazo1vio")) continue;
            SightingTaxon updated = SightingTaxons.newSightingTaxon("spAmazo1vin");
            sightingsToRemove.add(sighting);
            sightingsToAdd.add(sighting.asBuilder().setTaxon(updated).build());
        }
        if (sightingsToAdd.isEmpty()) {
            return false;
        }
        reportSet.mutator().adding(sightingsToAdd).removing(sightingsToRemove).mutate();
        return true;
    }
}

