/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class SplitNetherlandsAntilles
implements Upgrader {
    private static final String NETHERLANDS_ANTILLES = "Netherlands Antilles";

    @Inject
    SplitNetherlandsAntilles() {
    }

    @Override
    public String getVersion() {
        return "12.1.1";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Location southAmerica = this.getBuiltInLocation(locations, "South America");
        Location westIndies = this.getBuiltInLocation(locations, "West Indies");
        if (southAmerica != null && westIndies != null) {
            Location curaco;
            if (southAmerica.getContent(NETHERLANDS_ANTILLES) != null) {
                return;
            }
            Location westIndiesNetherlandsAntilles = westIndies.getContent(NETHERLANDS_ANTILLES);
            if (westIndiesNetherlandsAntilles == null) {
                return;
            }
            Location southAmericaNetherlandsAntilles = Location.builder().setBuiltInPrefix("ct").setEbirdCode("AN").setName(NETHERLANDS_ANTILLES).setType(Location.Type.country).setParent(southAmerica).build();
            locations.addLocation(southAmericaNetherlandsAntilles);
            Location bonaire = westIndiesNetherlandsAntilles.getContent("Bonaire");
            if (bonaire != null) {
                bonaire.reparent(southAmericaNetherlandsAntilles);
            }
            if ((curaco = westIndiesNetherlandsAntilles.getContent("Cura\u00e7ao")) != null) {
                curaco.reparent(southAmericaNetherlandsAntilles);
            }
        }
    }

    private Location getBuiltInLocation(LocationSet locations, String name) {
        Collection<Location> locationsByName = locations.getLocationsByModelName(name);
        for (Location location : locationsByName) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }
}

