/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class SplitAfricanExclavesFromSpain
implements Upgrader {
    private static final String CEUTA_MELILLA_CODE = "ES-CEUMEL";

    @Inject
    SplitAfricanExclavesFromSpain() {
    }

    @Override
    public String getVersion() {
        return "12.1.1";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        Location melilla;
        LocationSet locations = reportSet.getLocations();
        if (locations.getLocationByCode(CEUTA_MELILLA_CODE) != null) {
            return;
        }
        Location africa = this.getBuiltInLocation(locations, "Africa");
        if (africa == null) {
            return;
        }
        Location ceutaAndMelilla = Location.builder().setBuiltInPrefix("ct").setEbirdCode(CEUTA_MELILLA_CODE).setName("Ceuta and Melilla").setType(Location.Type.state).setParent(africa).build();
        locations.addLocation(ceutaAndMelilla);
        Location ceuta = locations.getLocationByCode("ES-CE");
        if (ceuta != null && "ES".equals(ceuta.getParent().getEbirdCode())) {
            ceuta.reparent(ceutaAndMelilla);
        }
        if ((melilla = locations.getLocationByCode("ES-ML")) != null && "ES".equals(melilla.getParent().getEbirdCode())) {
            melilla.reparent(ceutaAndMelilla);
        }
    }

    private Location getBuiltInLocation(LocationSet locations, String name) {
        Collection<Location> locationsByName = locations.getLocationsByModelName(name);
        for (Location location : locationsByName) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }
}

