/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;

class ReassignNewBuiltInLocations
implements Upgrader {
    private Provider<PredefinedLocations> predefinedLocationsProvider;

    @Inject
    ReassignNewBuiltInLocations(Provider<PredefinedLocations> predefinedLocationsProvider) {
        this.predefinedLocationsProvider = predefinedLocationsProvider;
    }

    @Override
    public String getVersion() {
        return "9999";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        for (Location location : ImmutableList.copyOf(locations.rootLocations())) {
            this.upgrade(reportSet, location);
        }
    }

    private void upgrade(ReportSet reportSet, Location location) {
        if (!location.isBuiltInLocation() && location.getParent() != null && location.getParent().isBuiltInLocation()) {
            PredefinedLocations.PredefinedLocation predefinedLocation;
            String locationName = location.getModelName();
            if (locationName.endsWith(" County")) {
                locationName = locationName.substring(0, locationName.length() - " County".length());
            }
            if ((predefinedLocation = this.predefinedLocationsProvider.get().getPredefinedLocationChildThatHasNotBeenCreatedYet(reportSet.getLocations(), location.getParent(), locationName)) == null) {
                return;
            }
            String name = predefinedLocation.getName();
            if (location.getParent().getContent(name) != null && location.getParent().getContent(name) != location) {
                return;
            }
            if (reportSet.getLocations().getLocationByCode(predefinedLocation.getCode()) != null) {
                return;
            }
            Location newLocation = predefinedLocation.create(reportSet.getLocations(), location.getParent());
            Locations.replaceLocation(newLocation, location, reportSet);
            location = newLocation;
        }
        for (Location child : ImmutableList.copyOf(location.contents())) {
            this.upgrade(reportSet, child);
        }
    }
}

