/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.OneTimeUpgrader;
import java.util.Set;

public class OneTimeUpgradeProcessor {
    private final ImmutableSet<OneTimeUpgrader> upgraders;

    @Inject
    OneTimeUpgradeProcessor(Set<OneTimeUpgrader> upgraders) {
        this.upgraders = ImmutableSet.copyOf(upgraders);
    }

    public void upgradeReportSet(ReportSet reportSet) {
        for (OneTimeUpgrader upgrader : this.upgraders) {
            if (reportSet.oneTimeUpgrades().contains(upgrader.getName())) continue;
            reportSet.addOneTimeUpgrader(upgrader.getName());
            if (!upgrader.upgrade(reportSet)) continue;
            reportSet.markDirty();
        }
    }
}

