/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class MoveSinaiToAsia
implements Upgrader {
    @Inject
    MoveSinaiToAsia() {
    }

    @Override
    public String getVersion() {
        return "18.1.0";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        Location shamalSinai;
        LocationSet locations = reportSet.getLocations();
        Location asia = this.findAsia(locations);
        if (asia == null) {
            return;
        }
        Location africa = this.findAfrica(locations);
        if (africa == null) {
            return;
        }
        Location egyptInAsia = asia.getContent("Egypt");
        if (egyptInAsia != null && egyptInAsia.isBuiltInLocation()) {
            return;
        }
        Location newEgyptInAsia = Location.builder().setEbirdCode("EG").setName("Egypt").setParent(asia).setType(Location.Type.country).setBuiltInPrefix("ct").build();
        if (egyptInAsia != null) {
            Locations.replaceLocation(newEgyptInAsia, egyptInAsia, reportSet);
        } else {
            reportSet.getLocations().ensureAdded(newEgyptInAsia);
        }
        reportSet.markDirty();
        egyptInAsia = newEgyptInAsia;
        Location egyptInAfrica = africa.getContent("Egypt");
        if (egyptInAfrica == null) {
            return;
        }
        Location janubSinai = reportSet.getLocations().getLocationByCode("EG-JS");
        if (janubSinai != null) {
            this.moveToAsiaIfInAfrica(janubSinai, egyptInAfrica, egyptInAsia, reportSet);
        }
        if ((shamalSinai = reportSet.getLocations().getLocationByCode("EG-SIN")) != null) {
            this.moveToAsiaIfInAfrica(shamalSinai, egyptInAfrica, egyptInAsia, reportSet);
        }
    }

    private void moveToAsiaIfInAfrica(Location sinai, Location egyptInAfrica, Location egyptInAsia, ReportSet reportSet) {
        if (Locations.isDescendentOfLocation(egyptInAfrica, sinai)) {
            Locations.reparentReplacingIfNeeded(sinai, egyptInAsia, reportSet);
            reportSet.markDirty();
        }
    }

    private Location findAsia(LocationSet locations) {
        Collection<Location> asias = locations.getLocationsByModelName("Asia");
        for (Location asia : asias) {
            if (!asia.isBuiltInLocation()) continue;
            return asia;
        }
        return null;
    }

    private Location findAfrica(LocationSet locations) {
        Collection<Location> africas = locations.getLocationsByModelName("Africa");
        for (Location africa : africas) {
            if (!africa.isBuiltInLocation()) continue;
            return africa;
        }
        return null;
    }
}

