/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class MoveSeveralCountriesToAustralasia
implements Upgrader {
    @Inject
    MoveSeveralCountriesToAustralasia() {
    }

    @Override
    public String getVersion() {
        return "13.7.0";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Location australasia = this.findAustralasia(locations);
        if (australasia == null) {
            return;
        }
        Location vanuatu = this.findPacificCountry(locations, "Vanuatu", "VU");
        Location newCaledonia = this.findPacificCountry(locations, "New Caledonia", "NC");
        Location newZealand = this.findPacificCountry(locations, "New Zealand", "NZ");
        Location solomonIslands = this.findPacificCountry(locations, "Solomon Islands", "SB");
        Location norfolk = this.findPacificCountry(locations, "Norfolk Island", "NF");
        Location macquarie = this.findPacificCountry(locations, "Macquarie Island", "AU-TAS-Macquarie");
        this.moveToAustralasia(vanuatu, australasia, reportSet);
        this.moveToAustralasia(newCaledonia, australasia, reportSet);
        this.moveToAustralasia(newZealand, australasia, reportSet);
        this.moveToAustralasia(solomonIslands, australasia, reportSet);
        this.moveToAustralasia(norfolk, australasia, reportSet);
        this.moveToAustralasia(macquarie, australasia, reportSet);
    }

    private void moveToAustralasia(Location country, Location australasia, ReportSet reportSet) {
        if (country != null) {
            Locations.reparentReplacingIfNeeded(country, australasia, reportSet);
            reportSet.markDirty();
        }
    }

    private Location findPacificCountry(LocationSet locations, String name, String ebirdCode) {
        Collection<Location> countries = locations.getLocationsByModelName(name);
        for (Location country : countries) {
            if (!country.isBuiltInLocation() || !ebirdCode.equals(country.getEbirdCode()) || country.getParent() == null || !"Pacific Ocean".equals(country.getParent().getModelName())) continue;
            return country;
        }
        return null;
    }

    private Location findAustralasia(LocationSet locations) {
        Collection<Location> australasias = locations.getLocationsByModelName("Australasia");
        for (Location australasia : australasias) {
            if (!australasia.isBuiltInLocation()) continue;
            return australasia;
        }
        return null;
    }
}

