/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class MoveSeveralCountriesToAsia
implements Upgrader {
    @Inject
    MoveSeveralCountriesToAsia() {
    }

    @Override
    public String getVersion() {
        return "10.0.0";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Location asia = this.findAsia(locations);
        if (asia == null) {
            return;
        }
        Location cyprus = this.findEuropeanCountry(locations, "Cyprus", "CY");
        Location armenia = this.findEuropeanCountry(locations, "Armenia", "AM");
        Location azerbaijan = this.findEuropeanCountry(locations, "Azerbaijan", "AZ");
        Location georgia = this.findEuropeanCountry(locations, "Georgia", "GE");
        this.moveToAsia(locations, cyprus, asia);
        this.moveToAsia(locations, armenia, asia);
        this.moveToAsia(locations, azerbaijan, asia);
        this.moveToAsia(locations, georgia, asia);
    }

    private void moveToAsia(LocationSet locations, Location country, Location asia) {
        if (country != null) {
            country.reparent(asia);
            locations.markDirty();
        }
    }

    private Location findEuropeanCountry(LocationSet locations, String name, String ebirdCode) {
        Collection<Location> countries = locations.getLocationsByModelName(name);
        for (Location country : countries) {
            if (!country.isBuiltInLocation() || !ebirdCode.equals(country.getEbirdCode()) || country.getParent() == null || !"Europe".equals(country.getParent().getModelName())) continue;
            return country;
        }
        return null;
    }

    private Location findAsia(LocationSet locations) {
        Collection<Location> asias = locations.getLocationsByModelName("Asia");
        for (Location asia : asias) {
            if (!asia.isBuiltInLocation()) continue;
            return asia;
        }
        return null;
    }
}

