/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class MoveSanAndresToTheWestIndies
implements Upgrader {
    private static final String SAN_ANDRES_NAME = "San Andr\u00e9s, Providencia y Santa Catalina";

    @Inject
    MoveSanAndresToTheWestIndies() {
    }

    @Override
    public String getVersion() {
        return "12.1.1";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Location westIndies = this.getBuiltInLocation(locations, "West Indies");
        if (westIndies != null) {
            Location sanAndres = locations.getLocationByCode("CO-SAP");
            if (sanAndres == null) {
                if (westIndies.getContent(SAN_ANDRES_NAME) == null) {
                    sanAndres = Location.builder().setBuiltInPrefix("ct").setEbirdCode("CO-SAP").setName(SAN_ANDRES_NAME).setParent(westIndies).setType(Location.Type.state).build();
                    locations.addLocation(sanAndres);
                    locations.markDirty();
                }
            } else if ("CO".equals(sanAndres.getParent().getEbirdCode())) {
                sanAndres.reparent(westIndies);
                locations.markDirty();
            }
        }
    }

    private Location getBuiltInLocation(LocationSet locations, String name) {
        Collection<Location> locationsByName = locations.getLocationsByModelName(name);
        for (Location location : locationsByName) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }
}

