/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class MovePalauOutOfMicronesia
implements Upgrader {
    @Inject
    MovePalauOutOfMicronesia() {
    }

    @Override
    public String getVersion() {
        return "12.4.0";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Collection<Location> palaus = locations.getLocationsByModelName("Palau");
        Collection<Location> micronesias = locations.getLocationsByModelName("Micronesia");
        Location palau = this.getLocationWithEbirdCode(palaus, "PW");
        Location micronesia = this.getLocationWithEbirdCode(micronesias, "FM");
        if (palau != null && micronesia != null && palau.getParent() == micronesia) {
            palau.reparent(micronesia.getParent());
            locations.markDirty();
        }
    }

    private Location getLocationWithEbirdCode(Collection<Location> locations, String ebirdCode) {
        for (Location location : locations) {
            if (!ebirdCode.equals(location.getEbirdCode())) continue;
            return location;
        }
        return null;
    }
}

