/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class MoveIsleOfManAndChannelIslandsOutOfUk
implements Upgrader {
    @Inject
    MoveIsleOfManAndChannelIslandsOutOfUk() {
    }

    @Override
    public String getVersion() {
        return "14.9.1";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Location europe = this.findEurope(locations);
        if (europe == null) {
            return;
        }
        Location isleOfMan = locations.getLocationByCode("IM");
        Location guernsey = locations.getLocationByCode("GG");
        Location jersey = locations.getLocationByCode("JE");
        this.moveToEuropeIfInUk(reportSet, isleOfMan, europe);
        this.moveToEuropeIfInUk(reportSet, guernsey, europe);
        this.moveToEuropeIfInUk(reportSet, jersey, europe);
    }

    private void moveToEuropeIfInUk(ReportSet reportSet, Location country, Location europe) {
        if (country != null && "GB".equals(country.getParent().getEbirdCode())) {
            Locations.reparentReplacingIfNeeded(country, europe, reportSet);
            country.reparent(europe);
            reportSet.markDirty();
        }
    }

    private Location findEurope(LocationSet locations) {
        Collection<Location> europes = locations.getLocationsByModelName("Europe");
        for (Location europe : europes) {
            if (!europe.isBuiltInLocation()) continue;
            return europe;
        }
        return null;
    }
}

