/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class MoveCanaryIslandsToAfricaAndFixEBirdCode
implements Upgrader {
    private static final String CORRECT_CANARY_ISLANDS_EBIRD_CODE = "ES-CN";
    private static final String CANARY_ISLANDS_NAME = "Canary Islands";

    @Inject
    MoveCanaryIslandsToAfricaAndFixEBirdCode() {
    }

    @Override
    public String getVersion() {
        return "12.4.0";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Location canariasProvince = locations.getLocationByCode(CORRECT_CANARY_ISLANDS_EBIRD_CODE);
        if (canariasProvince != null && !"ES".equals(canariasProvince.getParent().getEbirdCode())) {
            return;
        }
        Location africa = this.getBuiltInLocation(locations, "Africa");
        if (africa != null) {
            Object canaryIslands = locations.getLocationByCode("IC");
            if (canaryIslands == null) {
                if (canariasProvince != null) {
                    return;
                }
                if (africa.getContent(CANARY_ISLANDS_NAME) == null) {
                    canaryIslands = Location.builder().setBuiltInPrefix("ct").setEbirdCode(CORRECT_CANARY_ISLANDS_EBIRD_CODE).setName(CANARY_ISLANDS_NAME).setParent(africa).setType(Location.Type.state).build();
                    locations.addLocation((Location)canaryIslands);
                    locations.markDirty();
                }
            } else if (((Location)canaryIslands).getParent() == africa && !((Location)canaryIslands).getEbirdCode().equals(CORRECT_CANARY_ISLANDS_EBIRD_CODE)) {
                Location fixed = Location.builder().setEbirdCode(CORRECT_CANARY_ISLANDS_EBIRD_CODE).setName(((Location)canaryIslands).getModelName()).setParent(((Location)canaryIslands).getParent()).setType(((Location)canaryIslands).getType()).build();
                reportSet.replaceLocation((Location)canaryIslands, fixed);
                canaryIslands = fixed;
            }
            if (canariasProvince != null) {
                for (Location child : ImmutableList.copyOf(canariasProvince.contents())) {
                    child.reparent((Location)canaryIslands);
                }
                canariasProvince.reparent((Location)canaryIslands);
                Location clearTheCode = Location.builder().setName(canariasProvince.getModelName()).setParent(canariasProvince.getParent()).setType(canariasProvince.getType()).build();
                reportSet.replaceLocation(canariasProvince, clearTheCode);
                reportSet.deleteLocation(clearTheCode);
            }
        }
    }

    private Location getBuiltInLocation(LocationSet locations, String name) {
        Collection<Location> locationsByName = locations.getLocationsByModelName(name);
        for (Location location : locationsByName) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }
}

