/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class MoveAzoresAndMadeiraBackToEurope
implements Upgrader {
    @Inject
    MoveAzoresAndMadeiraBackToEurope() {
    }

    @Override
    public String getVersion() {
        return "13.8.2";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Location europe = this.findEurope(locations);
        if (europe == null) {
            return;
        }
        Location azores = locations.getLocationByCode("PT-20");
        Location madeira = locations.getLocationByCode("PT-30");
        this.moveToEuropeIfInAtlantic(reportSet, azores, europe);
        this.moveToEuropeIfInAtlantic(reportSet, madeira, europe);
    }

    private void moveToEuropeIfInAtlantic(ReportSet reportSet, Location country, Location europe) {
        if (country != null && country.getParent().getModelName().equals("Atlantic Ocean")) {
            Locations.reparentReplacingIfNeeded(country, europe, reportSet);
            country.reparent(europe);
            reportSet.markDirty();
        }
    }

    private Location findEurope(LocationSet locations) {
        Collection<Location> europes = locations.getLocationsByModelName("Europe");
        for (Location europe : europes) {
            if (!europe.isBuiltInLocation()) continue;
            return europe;
        }
        return null;
    }
}

