/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;
import java.util.Optional;

class KeepHawaiiInThePacific
implements Upgrader {
    @Inject
    KeepHawaiiInThePacific() {
    }

    @Override
    public String getVersion() {
        return "13.3.0";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        Location hawaiiInNorthAmerica;
        LocationSet locations = reportSet.getLocations();
        Location hawaii = locations.getLocationByCode("US-HI");
        if (hawaii == null) {
            return;
        }
        Collection<Location> allUnitedStates = locations.getLocationsByModelName("United States");
        Optional<Location> northAmericanUnitedStates = this.findNorthAmericanUnitedStates(allUnitedStates);
        if (northAmericanUnitedStates.isPresent() && (hawaiiInNorthAmerica = northAmericanUnitedStates.get().getContent("Hawaii")) != null && hawaiiInNorthAmerica != hawaii) {
            Locations.replaceLocation(hawaii, hawaiiInNorthAmerica, reportSet);
        }
    }

    private Optional<Location> findNorthAmericanUnitedStates(Collection<Location> allUnitedStates) {
        return allUnitedStates.stream().filter(l -> l.getParent().getModelName().equals("North America")).findAny();
    }
}

