/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class GiveMacquarieAnEbirdCode
implements Upgrader {
    private static final String MACQUARIE_CODE = "AU-TAS-Macquarie";

    @Inject
    GiveMacquarieAnEbirdCode() {
    }

    @Override
    public String getVersion() {
        return "12.1.1";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Location macquarie = this.getBuiltInLocation(locations, "Macquarie Island");
        if (macquarie != null && !MACQUARIE_CODE.equals(macquarie.getEbirdCode())) {
            Location newMacquarie = Location.builder().setName(macquarie.getModelName()).setType(macquarie.getType()).setParent(macquarie.getParent()).setEbirdCode(MACQUARIE_CODE).build();
            reportSet.replaceLocation(macquarie, newMacquarie);
        }
    }

    private Location getBuiltInLocation(LocationSet locations, String name) {
        Collection<Location> locationsByName = locations.getLocationsByModelName(name);
        for (Location location : locationsByName) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }
}

