/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class GiveJuanFernandezAnEbirdCode
implements Upgrader {
    private static final String JUAN_FERNANDEZ_CODE = "CL-VS-JuanFernandez";

    @Inject
    GiveJuanFernandezAnEbirdCode() {
    }

    @Override
    public String getVersion() {
        return "12.1.1";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Location juanFernandez = this.getBuiltInLocation(locations, "Juan Fernandez Islands");
        if (juanFernandez != null && !JUAN_FERNANDEZ_CODE.equals(juanFernandez.getEbirdCode())) {
            Location newJuanFernandezIsland = Location.builder().setName(juanFernandez.getModelName()).setType(juanFernandez.getType()).setParent(juanFernandez.getParent()).setEbirdCode(JUAN_FERNANDEZ_CODE).build();
            reportSet.replaceLocation(juanFernandez, newJuanFernandezIsland);
        }
    }

    private Location getBuiltInLocation(LocationSet locations, String name) {
        Collection<Location> locationsByName = locations.getLocationsByModelName(name);
        for (Location location : locationsByName) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }
}

