/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class GiveEasterIslandAnEbirdCode
implements Upgrader {
    private static final String EASTER_ISLAND_CODE = "CL-VS-Easter";

    @Inject
    GiveEasterIslandAnEbirdCode() {
    }

    @Override
    public String getVersion() {
        return "12.1.1";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Location easterIsland = this.getBuiltInLocation(locations, "Easter Island");
        if (easterIsland != null && !EASTER_ISLAND_CODE.equals(easterIsland.getEbirdCode())) {
            Location newEasterIsland = Location.builder().setName(easterIsland.getModelName()).setType(easterIsland.getType()).setParent(easterIsland.getParent()).setEbirdCode(EASTER_ISLAND_CODE).build();
            reportSet.replaceLocation(easterIsland, newEasterIsland);
        }
    }

    private Location getBuiltInLocation(LocationSet locations, String name) {
        Collection<Location> locationsByName = locations.getLocationsByModelName(name);
        for (Location location : locationsByName) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }
}

