/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class GalapagosAndSocotraEbirdCodes
implements Upgrader {
    @Inject
    GalapagosAndSocotraEbirdCodes() {
    }

    @Override
    public String getVersion() {
        return "10.0.0";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        Location socotra;
        LocationSet locations = reportSet.getLocations();
        Location galapagos = this.getBuiltInLocation(locations, "Galapagos Islands");
        if (galapagos != null && !"EC-W".equals(galapagos.getEbirdCode())) {
            Location newGalapagos = Location.builder().setName(galapagos.getModelName()).setType(galapagos.getType()).setParent(galapagos.getParent()).setEbirdCode("EC-W").build();
            reportSet.replaceLocation(galapagos, newGalapagos);
        }
        if ((socotra = this.getBuiltInLocation(locations, "Socotra")) != null && !"YE-HD-SOC".equals(socotra.getEbirdCode())) {
            Location newSocotra = Location.builder().setName(socotra.getModelName()).setType(socotra.getType()).setParent(socotra.getParent()).setEbirdCode("YE-HD-SOC").build();
            reportSet.replaceLocation(socotra, newSocotra);
        }
    }

    private Location getBuiltInLocation(LocationSet locations, String name) {
        Collection<Location> locationsByName = locations.getLocationsByModelName(name);
        for (Location location : locationsByName) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }
}

