/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class FixUruguayEbirdCode
implements Upgrader {
    @Inject
    FixUruguayEbirdCode() {
    }

    @Override
    public String getVersion() {
        return "10.0.0";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Collection<Location> uruguays = locations.getLocationsByModelName("Uruguay");
        for (Location uruguay : ImmutableList.copyOf(uruguays)) {
            if ("UY".equals(uruguay.getEbirdCode()) || uruguay.getType() != Location.Type.country) continue;
            Location fixed = Location.builder().setEbirdCode("UY").setName(uruguay.getModelName()).setParent(uruguay.getParent()).setType(uruguay.getType()).build();
            reportSet.replaceLocation(uruguay, fixed);
        }
    }
}

