/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class FixSloveniaEbirdCode
implements Upgrader {
    @Inject
    FixSloveniaEbirdCode() {
    }

    @Override
    public String getVersion() {
        return "9.3.1";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Collection<Location> slovenias = locations.getLocationsByModelName("Slovenia");
        for (Location slovenia : ImmutableList.copyOf(slovenias)) {
            if (!"SL".equals(slovenia.getEbirdCode())) continue;
            Location fixed = Location.builder().setEbirdCode("SI").setName(slovenia.getModelName()).setParent(slovenia.getParent()).setType(slovenia.getType()).build();
            reportSet.replaceLocation(slovenia, fixed);
        }
    }
}

