/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class FixShagRocks
implements Upgrader {
    @Inject
    FixShagRocks() {
    }

    @Override
    public String getVersion() {
        return "12.1.1";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        Location shagRocks;
        LocationSet locations = reportSet.getLocations();
        Location southPolar = this.getBuiltInLocation(locations, "South Polar Region");
        if (southPolar != null && (shagRocks = southPolar.getContent("Shag Rocks")) != null) {
            if (shagRocks.contents().isEmpty() && !this.anySightingsIn(reportSet, shagRocks)) {
                reportSet.deleteLocation(shagRocks);
            } else {
                Location southGeorgia = locations.getLocationByCode("GS");
                if (southGeorgia != null) {
                    shagRocks.reparent(southGeorgia);
                    locations.markDirty();
                }
            }
        }
    }

    private boolean anySightingsIn(ReportSet reportSet, Location kerguelen) {
        return Iterables.any(reportSet.getSightings(), SightingPredicates.in(kerguelen, reportSet.getLocations()));
    }

    private Location getBuiltInLocation(LocationSet locations, String name) {
        Collection<Location> locationsByName = locations.getLocationsByModelName(name);
        for (Location location : locationsByName) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }
}

