/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.ImmutableMap;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Map;

abstract class FixParents
implements Upgrader {
    private final PredefinedLocations predefinedLocations;

    protected FixParents(PredefinedLocations predefinedLocations) {
        this.predefinedLocations = predefinedLocations;
    }

    protected abstract ImmutableMap<String, String> locationToParent();

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        for (Map.Entry entry : this.locationToParent().entrySet()) {
            Location neededParent;
            Location location = locations.getLocationByCode((String)entry.getKey());
            if (location == null || (neededParent = Locations.getLocationByCodePossiblyCreating(locations, this.predefinedLocations, (String)entry.getValue())) == null || location.getParent() == neededParent) continue;
            locations.ensureAdded(neededParent);
            location.reparent(neededParent);
        }
    }
}

