/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Map;

class FixNepalProvinces
implements Upgrader {
    private static final ImmutableMap<String, String> OLD_NEPAL_LOCATIONS_BY_CODE = ImmutableMap.of("NP-1", "Madhyamanchal", "NP-2", "Madhya Pashchimanchal", "NP-3", "Pashchimanchal", "NP-4", "Purwanchal", "NP-5", "Sudur Pashchimanchal");

    @Inject
    FixNepalProvinces() {
    }

    @Override
    public String getVersion() {
        return "18.1.0";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        for (Map.Entry entry : OLD_NEPAL_LOCATIONS_BY_CODE.entrySet()) {
            Location existingState = locations.getLocationByCode((String)entry.getKey());
            if (existingState == null || !existingState.getModelName().equals(entry.getValue())) continue;
            Location legacyState = Location.builder().setName((String)entry.getValue() + " (pre-2016 state)").setParent(existingState.getParent()).build();
            Locations.replaceLocation(legacyState, existingState, reportSet);
            reportSet.markDirty();
        }
    }
}

