/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Map;

abstract class FixMultipleEbirdCodes
implements Upgrader {
    protected FixMultipleEbirdCodes() {
    }

    protected abstract ImmutableMap<String, String> oldCodeToNewCode();

    protected ImmutableSet<String> codesToRemove() {
        return ImmutableSet.of();
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        for (Map.Entry entry : this.oldCodeToNewCode().entrySet()) {
            if (locations.getLocationByCode((String)entry.getValue()) != null) continue;
            for (Location location : ImmutableList.copyOf(locations.getLocationsByCode((String)entry.getKey()))) {
                Location fixed = location.asBuilder().setEbirdCode((String)entry.getValue()).build();
                reportSet.replaceLocation(location, fixed);
            }
        }
        for (String codeToRemove : this.codesToRemove()) {
            for (Location location : ImmutableList.copyOf(locations.getLocationsByCode(codeToRemove))) {
                this.deleteSafely(reportSet, location);
            }
        }
    }

    private void deleteSafely(ReportSet reportSet, Location location) {
        for (Location child : ImmutableSet.copyOf(location.contents())) {
            Locations.reparentReplacingIfNeeded(child, location.getParent(), reportSet);
        }
        reportSet.deleteLocation(location);
    }
}

