/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import java.util.Map;

class FixMultipleCountryNames {
    private final ImmutableMap<String, String> codeToNameMap;

    public FixMultipleCountryNames(Map<String, String> codeToNameMap) {
        this.codeToNameMap = ImmutableMap.copyOf(codeToNameMap);
    }

    public boolean upgrade(ReportSet reportSet) {
        boolean madeChanges = false;
        LocationSet locations = reportSet.getLocations();
        for (Map.Entry codeAndName : this.codeToNameMap.entrySet()) {
            for (Location location : ImmutableList.copyOf(locations.getLocationsByCode((String)codeAndName.getKey()))) {
                if (((String)codeAndName.getValue()).equals(location.getModelName())) continue;
                String newName = (String)codeAndName.getValue();
                this.fixName(reportSet, locations, location, newName);
                madeChanges = true;
            }
        }
        return madeChanges;
    }

    private void fixName(ReportSet reportSet, LocationSet locations, Location location, String newName) {
        Location existingWithName = location.getParent().getContent(newName);
        if (existingWithName == null) {
            Location fixedName = location.asBuilder().setName(newName).build();
            reportSet.replaceLocation(location, fixedName);
            return;
        }
        if (location.getContent(newName) != null) {
            return;
        }
        for (Location content : existingWithName.contents()) {
            if (location.getContent(content.getModelName()) == null) continue;
            return;
        }
        for (Location content : ImmutableList.copyOf(existingWithName.contents())) {
            content.reparent(location);
        }
        existingWithName.reparent(location);
        reportSet.deleteLocation(existingWithName);
        Location fixedName = location.asBuilder().setName(newName).build();
        reportSet.replaceLocation(location, fixedName);
    }
}

