/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class FixKerguelenIsland
implements Upgrader {
    @Inject
    FixKerguelenIsland() {
    }

    @Override
    public String getVersion() {
        return "12.1.1";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        Location kerguelen;
        LocationSet locations = reportSet.getLocations();
        Location indianOcean = this.getBuiltInLocation(locations, "Indian Ocean");
        if (indianOcean != null && (kerguelen = indianOcean.getContent("Kerguelen Island")) != null) {
            if (kerguelen.contents().isEmpty() && !this.anySightingsIn(reportSet, kerguelen)) {
                reportSet.deleteLocation(kerguelen);
            } else {
                Location frenchSouthernAndAntarctica = locations.getLocationByCode("TF");
                if (frenchSouthernAndAntarctica != null) {
                    kerguelen.reparent(frenchSouthernAndAntarctica);
                    locations.markDirty();
                }
            }
        }
    }

    private boolean anySightingsIn(ReportSet reportSet, Location kerguelen) {
        return Iterables.any(reportSet.getSightings(), SightingPredicates.in(kerguelen, reportSet.getLocations()));
    }

    private Location getBuiltInLocation(LocationSet locations, String name) {
        Collection<Location> locationsByName = locations.getLocationsByModelName(name);
        for (Location location : locationsByName) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }
}

