/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.sighting.upgrades.OneTimeUpgrader;
import java.util.ArrayList;
import java.util.LinkedHashSet;

class FixIocVinaceousBreastedAmazonMapping
implements OneTimeUpgrader {
    @Inject
    FixIocVinaceousBreastedAmazonMapping() {
    }

    @Override
    public String getName() {
        return "VinBreastedAmazonIoc";
    }

    @Override
    public boolean upgrade(ReportSet reportSet) {
        ArrayList<Sighting> sightingsToRemove = new ArrayList<Sighting>();
        ArrayList<Sighting> sightingsToAdd = new ArrayList<Sighting>();
        for (Sighting sighting : reportSet.getSightings()) {
            if (!sighting.getTaxonomy().isBuiltIn() || !sighting.getTaxon().getIds().contains("spAmazo1vio") || !sighting.getTaxon().getIds().contains("spAmazo1vin")) continue;
            LinkedHashSet<String> taxa = new LinkedHashSet<String>();
            taxa.addAll(sighting.getTaxon().getIds());
            taxa.remove("spAmazo1vio");
            SightingTaxon updated = SightingTaxons.newPossiblySpTaxon(taxa);
            sightingsToRemove.add(sighting);
            sightingsToAdd.add(sighting.asBuilder().setTaxon(updated).build());
        }
        if (sightingsToAdd.isEmpty()) {
            return false;
        }
        reportSet.mutator().adding(sightingsToAdd).removing(sightingsToRemove).mutate();
        return true;
    }
}

