/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.sighting.upgrades.OneTimeUpgrader;
import java.util.ArrayList;

class FixIocCentralisAfricanGreyWoodpeckerMapping
implements OneTimeUpgrader {
    private static final ImmutableSet<String> COUNTRY_CODES_WHICH_MUST_BE_AFRICAN_GREY_CENTRALIS = ImmutableSet.of("SL", "LR", "CI", "GN", "GH", "TG", new String[]{"BJ", "BF", "BI", "NE", "NG", "CM", "CF", "SS", "RW", "KE", "UG"});

    @Inject
    FixIocCentralisAfricanGreyWoodpeckerMapping() {
    }

    @Override
    public String getName() {
        return "IocCentralisAfricanGreyWoodpecker";
    }

    @Override
    public boolean upgrade(ReportSet reportSet) {
        ArrayList<Sighting> sightingsToRemove = new ArrayList<Sighting>();
        ArrayList<Sighting> sightingsToAdd = new ArrayList<Sighting>();
        for (Sighting sighting : reportSet.getSightings()) {
            Location location;
            Location country;
            if (!sighting.getTaxonomy().isBuiltIn() || sighting.getTaxon().getType() != SightingTaxon.Type.SINGLE || !sighting.getTaxon().getId().equals("sspDendr4fuscen") || sighting.getLocationId() == null || (country = Locations.getAncestorOfType(location = reportSet.getLocations().getLocation(sighting.getLocationId()), Location.Type.country)) == null || !COUNTRY_CODES_WHICH_MUST_BE_AFRICAN_GREY_CENTRALIS.contains(country.getEbirdCode())) continue;
            SightingTaxon updated = SightingTaxons.newSightingTaxonWithSecondarySubspecies("grDendr4goe[go", "centralis");
            sightingsToRemove.add(sighting);
            sightingsToAdd.add(sighting.asBuilder().setTaxon(updated).build());
        }
        if (sightingsToAdd.isEmpty()) {
            return false;
        }
        reportSet.mutator().adding(sightingsToAdd).removing(sightingsToRemove).mutate();
        return true;
    }
}

