/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class FixHighSeas
implements Upgrader {
    @Inject
    FixHighSeas() {
    }

    @Override
    public String getVersion() {
        return "11.0.0";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        if (locations.getLocationByCode("XX") != null) {
            return;
        }
        Location atlanticOcean = this.getBuiltInLocation(locations, "Atlantic Ocean");
        Location arcticOcean = this.getBuiltInLocation(locations, "Arctic Ocean");
        Location indianOcean = this.getBuiltInLocation(locations, "Indian Ocean");
        Location pacificOcean = this.getBuiltInLocation(locations, "Pacific Ocean");
        Location southPolar = this.getBuiltInLocation(locations, "South Polar Region");
        this.addHighSeasTo(locations, atlanticOcean);
        this.addHighSeasTo(locations, arcticOcean);
        this.addHighSeasTo(locations, indianOcean);
        this.addHighSeasTo(locations, pacificOcean);
        this.addHighSeasTo(locations, southPolar);
    }

    private void addHighSeasTo(LocationSet locations, Location location) {
        if (location == null) {
            return;
        }
        Location existingHighSeas = location.getContent("High Seas");
        if (existingHighSeas != null) {
            return;
        }
        Location highSeas = Location.builder().setBuiltInPrefix("faam").setName("High Seas").setParent(location).setType(Location.Type.country).setEbirdCode("XX").build();
        locations.addLocation(highSeas);
    }

    private Location getBuiltInLocation(LocationSet locations, String name) {
        Collection<Location> locationsByName = locations.getLocationsByModelName(name);
        for (Location location : locationsByName) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }
}

