/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class FixGuamEbirdCode
implements Upgrader {
    @Inject
    FixGuamEbirdCode() {
    }

    @Override
    public String getVersion() {
        return "9.3.1";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Collection<Location> guams = locations.getLocationsByModelName("Guam");
        for (Location guam : ImmutableList.copyOf(guams)) {
            if (!"GT".equals(guam.getEbirdCode())) continue;
            Location fixed = Location.builder().setEbirdCode("GU").setName(guam.getModelName()).setParent(guam.getParent()).setType(guam.getType()).build();
            reportSet.replaceLocation(guam, fixed);
        }
    }
}

