/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class FixCanaryIslandsEbirdCode
implements Upgrader {
    @Inject
    FixCanaryIslandsEbirdCode() {
    }

    @Override
    public String getVersion() {
        return "9.3.1";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Collection<Location> canaries = locations.getLocationsByModelName("Canary Islands");
        for (Location canary : ImmutableList.copyOf(canaries)) {
            if (canary.getEbirdCode() != null || canary.getType() != Location.Type.country) continue;
            Location fixed = Location.builder().setEbirdCode("IC").setName(canary.getModelName()).setParent(canary.getParent()).setType(canary.getType()).build();
            reportSet.replaceLocation(canary, fixed);
        }
    }
}

