/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;
import java.util.logging.Logger;

class FixAzoresAndMadeira
implements Upgrader {
    private static final Logger logger = Logger.getLogger(FixAzoresAndMadeira.class.getName());

    @Inject
    FixAzoresAndMadeira() {
    }

    @Override
    public String getVersion() {
        return "10.0.0";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        Location atlanticOcean = this.getBuiltInLocation(locations, "Atlantic Ocean");
        this.upgradeAzores(locations, atlanticOcean, reportSet);
        this.upgradeMadeira(reportSet, locations);
    }

    private void upgradeAzores(LocationSet locations, Location atlanticOcean, ReportSet reportSet) {
        Location newAzores = Location.builder().setBuiltInPrefix("faam").setName("Azores").setParent(atlanticOcean).setType(Location.Type.state).setEbirdCode("PT-20").build();
        Collection<Location> allAzores = locations.getLocationsByModelName("Azores");
        if (allAzores.isEmpty()) {
            if (atlanticOcean == null) {
                logger.warning("No Atlantic Ocean!  Cannot add Azores");
            } else {
                locations.addLocation(newAzores);
            }
        } else {
            for (Location oldAzores : allAzores) {
                if (oldAzores.isBuiltInLocation()) {
                    return;
                }
                if (oldAzores.getParent() != atlanticOcean) continue;
                Locations.replaceLocation(newAzores, oldAzores, reportSet);
                return;
            }
        }
    }

    private void upgradeMadeira(ReportSet reportSet, LocationSet locations) {
        Location madeira = this.getBuiltInLocation(locations, "Madeira");
        if (madeira == null) {
            logger.warning("Madeira is missing");
        } else if (!"PT-30".equals(madeira.getEbirdCode())) {
            Location fixed = Location.builder().setEbirdCode("PT-30").setName(madeira.getModelName()).setParent(madeira.getParent()).setType(Location.Type.state).build();
            reportSet.replaceLocation(madeira, fixed);
        }
    }

    private Location getBuiltInLocation(LocationSet locations, String name) {
        Collection<Location> locationsByName = locations.getLocationsByModelName(name);
        for (Location location : locationsByName) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }
}

