/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.logging.Logger;

final class CountryCodeCleanupIn136
implements Upgrader {
    private static final Logger logger = Logger.getLogger(CountryCodeCleanupIn136.class.getName());
    private static final ImmutableList<String> LOCATIONS_TO_REMOVE = ImmutableList.of("CU-02", "FI-ES", "FI-IS", "FI-LS", "FI-OL", "LV-AI", "LV-AL", "LV-BL", "LV-BU", "LV-CE", "LV-DA", "LV-DGV", new String[]{"LV-DO", "LV-JEL", "LV-JK", "LV-JL", "LV-JUR", "LV-KR", "LV-KU", "LV-LE", "LV-LM", "LV-LPX", "LV-LU", "LV-MA", "LV-OG", "LV-PR", "LV-RE", "LV-REZ", "LV-RI", "LV-RIX", "LV-SA", "LV-TA", "LV-TU", "LV-VE", "LV-VK", "LV-VM"});
    private static final ImmutableMap<String, String> LOCATIONS_TO_MERGE = ImmutableMap.builder().put("PA-0", "PA-KY").put("AX", "FI-01").put("FI-AL", "FI-01").put("FI-LL", "FI-10").put("LV-GU", "LV-033").put("LV-VEN", "LV-106").put("RS-KM", "XK").build();
    private final PredefinedLocations predefinedLocations;

    @Inject
    CountryCodeCleanupIn136(PredefinedLocations predefinedLocations) {
        this.predefinedLocations = predefinedLocations;
    }

    @Override
    public String getVersion() {
        return "13.7.0";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        LOCATIONS_TO_MERGE.forEach((fromCode, intoCode) -> {
            Location from = locations.getLocationByCode((String)fromCode);
            if (from != null) {
                Location into = locations.getLocationByCode((String)intoCode);
                if (into == null && (into = Locations.getLocationByCodePossiblyCreating(locations, this.predefinedLocations, intoCode)) == null) {
                    logger.warning("Could not find country with predefined code " + intoCode + " to clean up " + fromCode);
                    return;
                }
                if (into.getModelName().equals(from.getModelName())) {
                    Location fromWithUpdatedCode = from.asBuilder().setEbirdCode((String)intoCode).build();
                    reportSet.replaceLocation(from, fromWithUpdatedCode);
                } else {
                    locations.ensureAdded(into);
                    Locations.reparentReplacingIfNeeded(from, into, reportSet);
                    this.deleteSafely(reportSet, from);
                }
            }
        });
        for (String locationCodeToRemove : LOCATIONS_TO_REMOVE) {
            Location location = locations.getLocationByCode(locationCodeToRemove);
            if (location == null) continue;
            this.deleteSafely(reportSet, location);
        }
    }

    private void deleteSafely(ReportSet reportSet, Location location) {
        for (Location child : Sets.newLinkedHashSet(location.contents())) {
            Locations.reparentReplacingIfNeeded(child, location.getParent(), reportSet);
        }
        reportSet.deleteLocation(location);
    }
}

