/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.upgrades;

import com.google.inject.Inject;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.upgrades.Upgrader;
import java.util.Collection;

class AddNewCountriesIn121
implements Upgrader {
    @Inject
    AddNewCountriesIn121() {
    }

    @Override
    public String getVersion() {
        return "12.1.1";
    }

    @Override
    public void upgrade(ReportSet reportSet) {
        LocationSet locations = reportSet.getLocations();
        this.addIfNecessary(locations, "French Southern and Antarctic Lands", "TF", "Indian Ocean", null);
        this.addIfNecessary(locations, "Ashmore and Cartier Islands", "AC", "Australasia", null);
        this.addIfNecessary(locations, "Coral Sea Islands", "CS", "Australasia", null);
        this.addIfNecessary(locations, "Prince Edward and Marion Islands", "ZA-WC-EdwardMarion", "Indian Ocean", null);
        this.addIfNecessary(locations, "Kosovo", "XK", "Europe", Location.Type.country);
    }

    private void addIfNecessary(LocationSet locations, String name, String code, String parent, Location.Type type) {
        Location existing;
        Location parentLocation;
        if (locations.getLocationByCode(code) == null && (parentLocation = this.getBuiltInLocation(locations, parent)) != null && (existing = parentLocation.getContent(name)) == null) {
            Location newLocation = Location.builder().setBuiltInPrefix("ct").setEbirdCode(code).setName(name).setParent(parentLocation).setType(type).build();
            locations.addLocation(newLocation);
            locations.markDirty();
        }
    }

    private Location getBuiltInLocation(LocationSet locations, String name) {
        Collection<Location> locationsByName = locations.getLocationsByModelName(name);
        for (Location location : locationsByName) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }
}

