/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.edits;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.sighting.Link;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.util.Dirty;
import com.scythebill.birdlist.model.util.DirtyImpl;
import com.scythebill.birdlist.model.util.ResolvedComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.joda.time.LocalTime;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;

public class SingleLocationEdit {
    private ReadablePartial date;
    private Location location;
    private List<SightingTaxon.Resolved> taxa = Lists.newArrayList();
    private Map<SightingTaxon.Resolved, SightingInfo> sightings = Maps.newLinkedHashMap();
    private String locationName;
    private ImmutableSet<Sighting> existingSightings;
    private DirtyImpl dirty = new DirtyImpl(false);
    private LocalTime time;
    private VisitInfo visitInfo;
    private VisitInfoKey snapshottedVisitInfoKey;
    private boolean completeChecklist;
    private ImmutableSet<User> users;
    private ImmutableSet<User> usersOnSpeciesList;
    private List<Link> tripLinks = new ArrayList<Link>();
    private boolean isTrip;
    private ReadablePartial endDate;
    private LocalTime endTime;
    private String tripName;
    private String tripNotes;
    private Trip snapshotTrip;

    public SingleLocationEdit(ReadablePartial date, Collection<User> defaultUsers) {
        this.date = date;
        this.users = ImmutableSet.copyOf(defaultUsers);
    }

    public void apply(ReportSet reportSet, Taxonomy currentTaxonomy) {
        Trip trip;
        Preconditions.checkNotNull(this.location, "No location set");
        LocationSet locations = reportSet.getLocations();
        if (this.location.getId() == null) {
            locations.ensureAdded(this.location);
        }
        if (this.isTrip()) {
            if (this.snapshotTrip != null) {
                trip = this.snapshotTrip;
                trip.setDates(this.date, this.endDate);
                trip.setTimes(this.time, this.endTime);
                trip.setLocation(this.location);
                trip.setName(Strings.emptyToNull(this.tripName));
                trip.setNotes(Strings.emptyToNull(this.tripNotes));
                trip.setLinks(this.tripLinks);
            } else {
                trip = reportSet.getTrips().newTripBuilder().withStartDate(this.date).withStartTime(this.time).withEndDate(this.endDate).withEndTime(this.endTime).withLocationId(this.location.getId()).withName(Strings.emptyToNull(this.tripName)).withNotes(Strings.emptyToNull(this.tripNotes)).withLinks(this.tripLinks).build();
            }
        } else {
            trip = null;
        }
        ArrayList<Sighting> newSightings = Lists.newArrayList();
        for (SightingTaxon.Resolved taxon : this.taxa) {
            SightingInfo info = this.sightings.get(taxon);
            Sighting.Builder builder = Sighting.newBuilder().setLocation(this.location).setTaxon(taxon);
            if (trip != null) {
                builder.setTrip(trip);
            } else {
                if (this.date != null) {
                    builder.setDate(new Partial(this.date));
                }
                if (this.time != null) {
                    builder.setTime(this.time);
                }
            }
            if (info != null) {
                builder.setSightingInfo(info);
            }
            newSightings.add(builder.build());
        }
        reportSet.mutator().removing(this.existingSightings).adding(newSightings).mutate();
        if (this.visitInfo != null && !this.isTrip()) {
            VisitInfoKey visitInfoKey = new VisitInfoKey(this.location.getId(), this.date, this.time);
            VisitInfo visitInfoToStore = this.visitInfo;
            if (this.completeChecklist) {
                visitInfoToStore = visitInfoToStore.asBuilder().withCompleteChecklist(true).build();
            }
            if (!visitInfoToStore.hasData()) {
                reportSet.removeVisitInfo(visitInfoKey);
            } else {
                reportSet.putVisitInfo(visitInfoKey, visitInfoToStore);
            }
        }
        this.dirty.setDirty(false);
        this.snapshotExistingSightings(reportSet, currentTaxonomy);
    }

    public boolean isTrip() {
        return this.isTrip;
    }

    public void setTrip(boolean isTrip) {
        this.isTrip = isTrip;
    }

    public ReadablePartial getDate() {
        return this.date;
    }

    public void setDate(ReadablePartial date) {
        this.date = date;
    }

    public ReadablePartial getEndDate() {
        return this.endDate;
    }

    public void setEndDate(ReadablePartial endDate) {
        this.endDate = endDate;
    }

    public LocalTime getTime() {
        return this.time;
    }

    public void setTime(LocalTime time) {
        this.time = time;
    }

    public LocalTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(LocalTime endTime) {
        this.endTime = endTime;
    }

    public void setUsers(Collection<User> users) {
        this.users = ImmutableSet.copyOf(users);
    }

    public ImmutableSet<User> getUsers() {
        return this.users;
    }

    public void setUsersOnSpeciesList(Collection<User> users) {
        this.usersOnSpeciesList = users == null ? null : ImmutableSet.copyOf(users);
    }

    public ImmutableSet<User> getUsersOnSpeciesList() {
        return this.usersOnSpeciesList;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setLocationName(String locationName) {
        this.locationName = locationName;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public List<SightingTaxon.Resolved> taxa() {
        return Collections.unmodifiableList(this.taxa);
    }

    public SightingInfo getSightingInfo(SightingTaxon.Resolved resolved) {
        SightingInfo sighting = this.sightings.get(resolved);
        if (sighting == null) {
            sighting = new SightingInfo();
            if (this.users != null && !this.users.isEmpty()) {
                sighting.setUsers(this.users);
            }
            this.sightings.put(resolved, sighting);
        }
        return sighting;
    }

    public void swapTaxa(SightingTaxon.Resolved oldTaxon, SightingTaxon.Resolved newTaxon) {
        if (this.sightings.containsKey(oldTaxon)) {
            SightingInfo info = this.sightings.remove(oldTaxon);
            this.sightings.put(newTaxon, info);
        }
        this.edited();
    }

    public void setTaxonomy(Taxonomy updated, Iterable<SightingTaxon.Resolved> updatedTaxa) {
        ArrayList<SightingTaxon.Resolved> newTaxa = Lists.newArrayList(updatedTaxa);
        LinkedHashMap<SightingTaxon.Resolved, SightingInfo> newSightings = Maps.newLinkedHashMap();
        for (SightingTaxon.Resolved previousResolved : this.taxa) {
            MappedTaxonomy mapped;
            SightingInfo previousSighting = this.getSightingInfo(previousResolved);
            if (!TaxonUtils.areCompatible(previousResolved.getTaxonomy(), updated)) {
                newSightings.put(previousResolved, previousSighting);
                newTaxa.add(previousResolved);
                continue;
            }
            Taxonomy previous = previousResolved.getTaxonomy();
            if (updated == previous) {
                newSightings.put(previousResolved, previousSighting);
                continue;
            }
            if (updated instanceof MappedTaxonomy) {
                mapped = (MappedTaxonomy)updated;
                Preconditions.checkState(previous == mapped.getBaseTaxonomy());
                SightingTaxon.Resolved resolved = mapped.resolveInto(previousResolved.getSightingTaxon());
                if (resolved == null) continue;
                newSightings.put(resolved, previousSighting);
                continue;
            }
            mapped = (MappedTaxonomy)previous;
            SightingTaxon baseMapping = mapped.getMapping(previousResolved.getSightingTaxon());
            SightingTaxon.Resolved resolved = updated.resolveInto(baseMapping);
            if (baseMapping == null) continue;
            newSightings.put(resolved, previousSighting);
        }
        this.taxa = newTaxa;
        this.sightings = newSightings;
    }

    public void setVisitInfo(VisitInfo visitInfo) {
        this.visitInfo = visitInfo;
    }

    public VisitInfo getVisitInfo() {
        return this.visitInfo;
    }

    public void setLocationText(String whereText) {
        this.setLocationName(whereText);
    }

    public Dirty getDirty() {
        return this.dirty;
    }

    public ExistingSightingSnapshotState getSnapshotState() {
        String locationId;
        if (this.existingSightings == null || this.existingSightings.isEmpty()) {
            return ExistingSightingSnapshotState.NONE;
        }
        Sighting sample = (Sighting)this.existingSightings.iterator().next();
        if (sample.getTrip() == null) {
            String locationId2;
            boolean dateHasChanged = !Objects.equal(this.date, sample.getStoredDateAsPartial());
            boolean timeHasChanged = !Objects.equal(this.time, sample.getStoredTimeAsPartial());
            String string = locationId2 = this.location == null ? null : this.location.getId();
            if (Objects.equal(locationId2, sample.getLocationId())) {
                if (timeHasChanged) {
                    return dateHasChanged ? ExistingSightingSnapshotState.DATE_AND_TIME_CHANGED : ExistingSightingSnapshotState.TIME_CHANGED;
                }
                return dateHasChanged ? ExistingSightingSnapshotState.DATE_CHANGED : ExistingSightingSnapshotState.NO_CHANGE;
            }
            if (timeHasChanged) {
                return dateHasChanged ? ExistingSightingSnapshotState.DATE_AND_AND_TIME_AND_LOCATION_CHANGED : ExistingSightingSnapshotState.TIME_AND_LOCATION_CHANGED;
            }
            return dateHasChanged ? ExistingSightingSnapshotState.DATE_AND_LOCATION_CHANGED : ExistingSightingSnapshotState.LOCATION_CHANGED;
        }
        Trip trip = sample.getTrip();
        boolean dateHasChanged = !Objects.equal(this.date, trip.startDate()) || !Objects.equal(this.endDate, trip.endDate());
        boolean timeHasChanged = !Objects.equal(this.time, trip.startTime()) || !Objects.equal(this.endTime, trip.endTime());
        String string = locationId = this.location == null ? null : this.location.getId();
        if (Objects.equal(locationId, trip.locationId())) {
            if (timeHasChanged) {
                return dateHasChanged ? ExistingSightingSnapshotState.DATE_AND_TIME_CHANGED : ExistingSightingSnapshotState.TIME_CHANGED;
            }
            return dateHasChanged ? ExistingSightingSnapshotState.DATE_CHANGED : ExistingSightingSnapshotState.NO_CHANGE;
        }
        if (timeHasChanged) {
            return dateHasChanged ? ExistingSightingSnapshotState.DATE_AND_AND_TIME_AND_LOCATION_CHANGED : ExistingSightingSnapshotState.TIME_AND_LOCATION_CHANGED;
        }
        return dateHasChanged ? ExistingSightingSnapshotState.DATE_AND_LOCATION_CHANGED : ExistingSightingSnapshotState.LOCATION_CHANGED;
    }

    public void clearSnapshot() {
        this.taxa.clear();
        this.sightings.clear();
        this.setVisitInfo(null);
        this.snapshottedVisitInfoKey = null;
    }

    public Trip findMatchingTrip(ReportSet reportSet) {
        String locationId = this.location == null ? null : this.location.getId();
        for (Trip trip : reportSet.getTrips().allTrips()) {
            if (!Objects.equal(this.date, trip.startDate()) || !Objects.equal(this.endDate, trip.endDate()) || !Objects.equal(locationId, trip.locationId())) continue;
            return trip;
        }
        return null;
    }

    public void snapshotExistingSightings(ReportSet reportSet, Taxonomy taxonomy) {
        String locationId = this.location == null ? null : this.location.getId();
        this.taxa.clear();
        this.sightings.clear();
        ImmutableSet.Builder existingSightings = ImmutableSet.builder();
        ImmutableSet.Builder existingSightingsWithoutTime = ImmutableSet.builder();
        if (this.isTrip) {
            this.snapshotTrip = this.findMatchingTrip(reportSet);
            if (this.snapshotTrip != null) {
                for (Sighting sighting : reportSet.getSightings()) {
                    if (sighting.getTrip() != this.snapshotTrip) continue;
                    existingSightings.add(sighting);
                }
            }
        } else {
            boolean hasVisitInfo;
            boolean bl = hasVisitInfo = this.visitInfo != null && this.visitInfo.hasData();
            if (this.snapshottedVisitInfoKey != null && hasVisitInfo && this.visitInfo.equals(reportSet.getVisitInfo(this.snapshottedVisitInfoKey))) {
                this.setVisitInfo(null);
                this.completeChecklist = false;
            }
            if (locationId != null) {
                if (this.date != null) {
                    VisitInfoKey visitInfoKey = new VisitInfoKey(locationId, this.date, this.time);
                    if (!hasVisitInfo) {
                        this.setVisitInfo(reportSet.getVisitInfo(visitInfoKey));
                        if (this.visitInfo != null) {
                            this.completeChecklist = this.visitInfo.completeChecklist();
                        }
                    }
                    this.snapshottedVisitInfoKey = visitInfoKey;
                }
                for (Sighting sighting : reportSet.getSightings()) {
                    if (!locationId.equals(sighting.getLocationId()) || !Objects.equal(sighting.getStoredDateAsPartial(), this.date)) continue;
                    if (Objects.equal(sighting.getStoredTimeAsPartial(), this.time)) {
                        existingSightings.add(sighting);
                        continue;
                    }
                    if (sighting.getStoredTimeAsPartial() != null) continue;
                    existingSightingsWithoutTime.add(sighting);
                }
            }
        }
        this.existingSightings = existingSightings.build();
        if (this.existingSightings.isEmpty()) {
            this.existingSightings = existingSightingsWithoutTime.build();
        }
        TreeSet<SightingTaxon.Resolved> sortedResolved = Sets.newTreeSet(new ResolvedComparator());
        for (Sighting existingSighting : this.existingSightings) {
            Taxonomy sightingTaxonomy = taxonomy;
            if (!TaxonUtils.areCompatible(taxonomy, existingSighting.getTaxonomy())) {
                sightingTaxonomy = existingSighting.getTaxonomy();
            }
            SightingTaxon.Resolved resolved = existingSighting.getTaxon().resolve(sightingTaxonomy);
            sortedResolved.add(resolved);
            this.sightings.put(resolved, existingSighting.getSightingInfo().clone());
        }
        this.taxa.addAll(sortedResolved);
    }

    public void edited() {
        this.dirty.setDirty(true);
    }

    public List<SightingTaxon.Resolved> getCompatibleTaxa(Taxonomy taxonomy) {
        ArrayList<SightingTaxon.Resolved> compatibleTaxa = Lists.newArrayList();
        for (SightingTaxon.Resolved resolved : this.taxa) {
            if (!TaxonUtils.areCompatible(taxonomy, resolved.getTaxonomy())) continue;
            compatibleTaxa.add(resolved);
        }
        return compatibleTaxa;
    }

    public int getIncompatibleTaxonomyCount(Taxonomy taxonomy) {
        int i = 0;
        for (SightingTaxon.Resolved resolved : this.taxa) {
            if (TaxonUtils.areCompatible(taxonomy, resolved.getTaxonomy())) continue;
            ++i;
        }
        return i;
    }

    public void syncTaxa(Taxonomy taxonomy, ImmutableList<SightingTaxon.Resolved> taxaForThisTaxonomy) {
        ArrayList<SightingTaxon.Resolved> newTaxa = Lists.newArrayList(taxaForThisTaxonomy);
        for (SightingTaxon.Resolved taxon : this.taxa) {
            if (TaxonUtils.areCompatible(taxonomy, taxon.getTaxonomy())) continue;
            newTaxa.add(taxon);
        }
        if (!this.taxa.equals(newTaxa)) {
            this.edited();
        }
        this.taxa = newTaxa;
    }

    public Collection<SightingInfo> getSightingInfos() {
        return this.sightings.values();
    }

    public boolean isEmpty() {
        return this.taxa.isEmpty();
    }

    public void setTripName(String tripName) {
        this.tripName = tripName;
    }

    public String getTripName() {
        return this.tripName;
    }

    public void setTripNotes(String tripNotes) {
        this.tripNotes = tripNotes;
    }

    public String getTripNotes() {
        return this.tripNotes;
    }

    public void setTripLinks(Collection<Link> links) {
        this.tripLinks = new ArrayList<Link>(links);
    }

    public List<Link> getTripLinks() {
        return this.tripLinks;
    }

    public static enum ExistingSightingSnapshotState {
        NONE,
        NO_CHANGE,
        DATE_CHANGED,
        DATE_AND_LOCATION_CHANGED,
        LOCATION_CHANGED,
        TIME_CHANGED,
        DATE_AND_TIME_CHANGED,
        DATE_AND_AND_TIME_AND_LOCATION_CHANGED,
        TIME_AND_LOCATION_CHANGED;

    }
}

