/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.edits;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.annotations.SerializeAsJson;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

@SerializeAsJson
public class RecentEdits {
    private static final int MAX_RECENT_EDITS = 10;
    private List<RecentEdit> recentEdits;
    private static final Comparator<Object> VISIT_OR_TRIP_ORDERING = Comparator.comparing(o -> {
        if (o instanceof VisitInfoKey) {
            VisitInfoKey vik = (VisitInfoKey)o;
            return vik.date();
        }
        if (o instanceof Trip) {
            Trip trip = (Trip)o;
            return trip.startDate();
        }
        return null;
    }, SightingComparators::comparePartials);

    public RecentEdits() {
        this.recentEdits = Lists.newArrayList();
    }

    RecentEdits(Iterable<RecentEdit> recentEdits) {
        this.recentEdits = Lists.newArrayList(recentEdits);
    }

    public static List<RecentEdit> getLastEdits(ReportSet reportSet, int count) {
        ArrayList<RecentEdit> recentEdits = Lists.newArrayList();
        RecentEdit lastEdit = null;
        for (Sighting sighting : Lists.reverse(reportSet.getSightings())) {
            RecentEdit newRecentEdit;
            if (sighting.getTrip() == null) {
                ReadablePartial date = sighting.getStoredDateAsPartial();
                String locationId = sighting.getLocationId();
                if (locationId == null || date == null) continue;
                newRecentEdit = new RecentEdit(locationId, date, sighting.getStoredTimeAsPartial());
            } else {
                newRecentEdit = new RecentEdit(sighting.getTrip().locationId(), sighting.getTrip().startDate(), sighting.getTrip().startTime(), sighting.getTrip().endDate(), sighting.getTrip().endTime());
            }
            if (lastEdit != null && newRecentEdit.equals(lastEdit) || recentEdits.contains(lastEdit = newRecentEdit)) continue;
            recentEdits.add(lastEdit);
            if (recentEdits.size() != count) continue;
            return recentEdits;
        }
        return recentEdits;
    }

    public List<RecentEdit> getRecentEditsList() {
        return Lists.newArrayList(this.recentEdits);
    }

    public void add(String locationId, ReadablePartial date, @Nullable ReadablePartial startTime) {
        RecentEdit recentEdit = new RecentEdit(locationId, date, startTime);
        int alreadyPresentIndex = this.recentEdits.indexOf(recentEdit);
        if (alreadyPresentIndex < 0) {
            this.recentEdits.add(0, recentEdit);
            while (this.recentEdits.size() > 10) {
                this.recentEdits.remove(10);
            }
        } else if (alreadyPresentIndex != 0) {
            this.recentEdits.remove(alreadyPresentIndex);
            this.recentEdits.add(0, recentEdit);
        }
    }

    public void add(Iterable<Object> visitInfoKeysAndTrips) {
        ImmutableList<Object> mostRecentFirst = ImmutableList.sortedCopyOf(VISIT_OR_TRIP_ORDERING.reversed(), visitInfoKeysAndTrips);
        ImmutableList<Object> trimmedSizeThenLastFirst = ImmutableList.sortedCopyOf(VISIT_OR_TRIP_ORDERING, Iterables.limit(mostRecentFirst, 10));
        for (Object e : trimmedSizeThenLastFirst) {
            if (e instanceof VisitInfoKey) {
                VisitInfoKey vik = (VisitInfoKey)e;
                this.add(vik);
                continue;
            }
            if (!(e instanceof Trip)) continue;
            Trip trip = (Trip)e;
            this.add(trip);
        }
    }

    private void add(VisitInfoKey visitInfoKey) {
        this.add(visitInfoKey.locationId(), visitInfoKey.date(), visitInfoKey.startTime().orNull());
    }

    private void add(Trip trip) {
        this.add(trip.locationId(), trip.startDate(), trip.startTime(), trip.endDate(), trip.endTime());
    }

    public void add(String locationId, ReadablePartial date, LocalTime startTime, ReadablePartial endDate, LocalTime endTime) {
        RecentEdit recentEdit = new RecentEdit(locationId, date, startTime, endDate, endTime);
        int alreadyPresentIndex = this.recentEdits.indexOf(recentEdit);
        if (alreadyPresentIndex < 0) {
            this.recentEdits.add(0, recentEdit);
            while (this.recentEdits.size() > 10) {
                this.recentEdits.remove(10);
            }
        } else if (alreadyPresentIndex != 0) {
            this.recentEdits.remove(alreadyPresentIndex);
            this.recentEdits.add(0, recentEdit);
        }
    }

    public static class RecentEdit {
        private final String locationId;
        private final String date;
        private final String startTime;
        private final String endDate;
        private final String endTime;

        RecentEdit(String locationId, String date, String startTime, String endDate, String endTime) {
            this.locationId = locationId;
            this.date = date;
            this.startTime = startTime;
            this.endDate = endDate;
            this.endTime = endTime;
        }

        RecentEdit(String locationId, ReadablePartial partial, ReadablePartial startTime) {
            this(locationId, PartialIO.toString(partial), startTime == null ? null : TimeIO.toString(startTime), null, null);
        }

        public RecentEdit(String locationId, ReadablePartial date, LocalTime startTime, ReadablePartial endDate, LocalTime endTime) {
            this(locationId, PartialIO.toString(date), startTime == null ? null : TimeIO.toString(startTime), PartialIO.toString(endDate), endTime == null ? null : TimeIO.toString(endTime));
        }

        public String getLocationId() {
            return this.locationId;
        }

        public ReadablePartial getDate() {
            return PartialIO.fromString(this.date);
        }

        @Nullable
        public LocalTime getStartTime() {
            return this.startTime == null ? null : TimeIO.fromString(this.startTime);
        }

        @Nullable
        public ReadablePartial getEndDate() {
            return this.endDate == null ? null : PartialIO.fromString(this.endDate);
        }

        @Nullable
        public LocalTime getEndTime() {
            return this.endTime == null ? null : TimeIO.fromString(this.endTime);
        }

        public int hashCode() {
            return Objects.hashCode(this.locationId, this.date, this.startTime, this.endDate, this.endTime);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RecentEdit)) {
                return false;
            }
            RecentEdit that = (RecentEdit)o;
            return Objects.equal(this.locationId, that.locationId) && Objects.equal(this.date, that.date) && Objects.equal(this.startTime, that.startTime) && Objects.equal(this.endDate, that.endDate) && Objects.equal(this.endTime, that.endTime);
        }
    }
}

