/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting.edits;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.scythebill.birdlist.model.annotations.SerializeAsJson;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.user.UserSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;

@SerializeAsJson
public class ChosenUsers {
    private LinkedHashSet<String> userIds = new LinkedHashSet();

    @Inject
    public ChosenUsers() {
    }

    public ImmutableSet<User> getUsers(UserSet userSet) {
        if (userSet == null) {
            return ImmutableSet.of();
        }
        return this.userIds.stream().filter(id -> userSet.hasUserWithId((String)id)).map(userSet::userById).collect(ImmutableSet.toImmutableSet());
    }

    public void setUsers(Collection<User> users) {
        this.userIds = users.stream().map(User::id).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

