/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.collect.Ordering;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;

public final class VisitInfoKeyOrdering
extends Ordering<VisitInfoKey> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compare(VisitInfoKey left, VisitInfoKey right) {
        int compareDates = SightingComparators.comparePartials(left.date(), right.date());
        if (compareDates != 0) {
            return compareDates;
        }
        if (left.startTime().isPresent()) {
            if (!right.startTime().isPresent()) return 1;
            int compareTimes = SightingComparators.comparePartials(left.startTime().get(), right.startTime().get());
            if (compareTimes == 0) return left.locationId().compareTo(right.locationId());
            return compareTimes;
        }
        if (!right.startTime().isPresent()) return left.locationId().compareTo(right.locationId());
        return -1;
    }
}

