/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.sighting.Sighting;
import javax.annotation.Nullable;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public final class VisitInfoKey {
    private final String locationId;
    private final ReadablePartial date;
    private final LocalTime startTime;

    public VisitInfoKey(String locationId, ReadablePartial date, @Nullable LocalTime startTime) {
        this.locationId = Preconditions.checkNotNull(locationId);
        this.date = Preconditions.checkNotNull(date);
        this.startTime = startTime;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VisitInfoKey)) {
            return false;
        }
        VisitInfoKey that = (VisitInfoKey)obj;
        return this.locationId.equals(that.locationId) && this.date.equals(that.date) && Objects.equal(this.startTime, that.startTime);
    }

    public int hashCode() {
        return 31 * (31 * this.locationId.hashCode() + this.date.hashCode()) + (this.startTime == null ? 0 : this.startTime.hashCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("locationId", this.locationId).add("date", PartialIO.toString(this.date)).add("startTime", this.startTime == null ? "null" : TimeIO.toString(this.startTime)).toString();
    }

    public String locationId() {
        return this.locationId;
    }

    public ReadablePartial date() {
        return this.date;
    }

    public Optional<LocalTime> startTime() {
        return Optional.fromNullable(this.startTime);
    }

    public static VisitInfoKey forSighting(Sighting sighting) {
        if (sighting.getLocationId() == null || sighting.getStoredDateAsPartial() == null) {
            return null;
        }
        return new VisitInfoKey(sighting.getLocationId(), sighting.getStoredDateAsPartial(), sighting.getStoredTimeAsPartial());
    }

    public boolean matches(Sighting sighting) {
        if (!Objects.equal(sighting.getLocationId(), this.locationId)) {
            return false;
        }
        if (!Objects.equal(sighting.getStoredDateAsPartial(), this.date)) {
            return false;
        }
        return Objects.equal(sighting.getStoredTimeAsPartial(), this.startTime);
    }

    public VisitInfoKey withLocationId(String newLocationId) {
        return new VisitInfoKey(newLocationId, this.date, this.startTime);
    }

    public VisitInfoKey withDate(ReadablePartial newDate) {
        return new VisitInfoKey(this.locationId, newDate, this.startTime);
    }

    public VisitInfoKey withStartTime(Optional<LocalTime> newStartTime) {
        return new VisitInfoKey(this.locationId, this.date, newStartTime.orNull());
    }
}

