/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.sighting.Area;
import com.scythebill.birdlist.model.sighting.Distance;
import com.scythebill.birdlist.model.sighting.Photo;
import java.util.Collection;
import java.util.HashMap;
import org.joda.time.Duration;

public class VisitInfo {
    private static final CharMatcher LETTERS_TO_STRIP_FROM_EBIRD_NAMES = CharMatcher.anyOf(" -");
    private final ObservationType observationType;
    private final Area area;
    private final Duration duration;
    private final Distance distance;
    private final Integer partySize;
    private final boolean completeChecklist;
    private final String comments;
    private final ImmutableList<Photo> photos;

    private VisitInfo(Builder builder) {
        Preconditions.checkState(builder.observationType != null, "No observationType");
        this.observationType = builder.observationType;
        ImmutableSet<VisitField> requiredFields = this.observationType.getRequiredFields();
        ImmutableSet<VisitField> hiddenFields = this.observationType.getHiddenFields();
        if (hiddenFields.contains((Object)VisitField.AREA)) {
            this.area = null;
        } else {
            if (builder.area == null) {
                Preconditions.checkState(!requiredFields.contains((Object)VisitField.AREA), "Observation type %s requires an area", (Object)this.observationType);
            }
            this.area = builder.area;
        }
        if (hiddenFields.contains((Object)VisitField.DURATION)) {
            this.duration = null;
        } else {
            if (builder.duration == null) {
                Preconditions.checkState(!requiredFields.contains((Object)VisitField.DURATION), "Observation type %s requires a duration", (Object)this.observationType);
            }
            this.duration = builder.duration;
        }
        if (hiddenFields.contains((Object)VisitField.DISTANCE)) {
            this.distance = null;
        } else {
            if (builder.distance == null) {
                Preconditions.checkState(!requiredFields.contains((Object)VisitField.DISTANCE), "Observation type %s requires a distance", (Object)this.observationType);
            }
            this.distance = builder.distance;
        }
        if (hiddenFields.contains((Object)VisitField.PARTY_SIZE)) {
            this.partySize = null;
        } else {
            if (builder.partySize == null) {
                Preconditions.checkState(!requiredFields.contains((Object)VisitField.PARTY_SIZE), "Observation type %s requires a party size", (Object)this.observationType);
            }
            this.partySize = builder.partySize;
        }
        this.completeChecklist = builder.completeChecklist;
        this.comments = Strings.emptyToNull(builder.comments);
        this.photos = builder.photos;
    }

    public ObservationType observationType() {
        return this.observationType;
    }

    public Optional<Duration> duration() {
        return Optional.fromNullable(this.duration);
    }

    public Optional<Distance> distance() {
        return Optional.fromNullable(this.distance);
    }

    public Optional<Area> area() {
        return Optional.fromNullable(this.area);
    }

    public Optional<Integer> partySize() {
        return Optional.fromNullable(this.partySize);
    }

    public Optional<String> comments() {
        return Optional.fromNullable(this.comments);
    }

    public ImmutableList<Photo> photos() {
        return this.photos == null ? ImmutableList.of() : this.photos;
    }

    public boolean completeChecklist() {
        return this.completeChecklist;
    }

    public Builder asBuilder() {
        Builder builder = VisitInfo.builder().withObservationType(this.observationType);
        if (this.duration != null) {
            builder.withDuration(this.duration);
        }
        if (this.distance != null) {
            builder.withDistance(this.distance);
        }
        if (this.area != null) {
            builder.withArea(this.area);
        }
        if (this.partySize != null) {
            builder.withPartySize(this.partySize);
        }
        if (this.comments != null) {
            builder.withComments(this.comments);
        }
        if (this.completeChecklist) {
            builder.withCompleteChecklist(true);
        }
        if (this.photos != null) {
            builder.withPhotos(this.photos);
        }
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("observationType", (Object)this.observationType).add("area", this.area).add("duration", this.duration).add("distance", this.distance).add("partySize", this.partySize).add("completeChecklist", this.completeChecklist).add("comments", this.comments).add("photos", this.photos).toString();
    }

    public boolean hasData() {
        return this.area != null || this.distance != null || this.duration != null || this.comments != null || this.partySize != null || this.completeChecklist || this.observationType == ObservationType.INCIDENTAL || this.photos != null && !this.photos.isEmpty();
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.area, this.comments, this.completeChecklist, this.distance, this.duration, this.observationType, this.partySize, this.photos});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VisitInfo)) {
            return false;
        }
        VisitInfo that = (VisitInfo)obj;
        return Objects.equal(this.area, that.area) && Objects.equal(this.comments, that.comments) && this.completeChecklist == that.completeChecklist && Objects.equal(this.distance, that.distance) && Objects.equal(this.duration, that.duration) && Objects.equal((Object)this.observationType, (Object)that.observationType) && Objects.equal(this.partySize, that.partySize) && Objects.equal(this.photos, that.photos);
    }

    public static class Builder {
        private String comments;
        private boolean completeChecklist;
        private Integer partySize;
        private Area area;
        private Distance distance;
        private Duration duration;
        private ObservationType observationType;
        private ImmutableList<Photo> photos;

        private Builder() {
        }

        public Builder withObservationType(ObservationType observationType) {
            this.observationType = observationType;
            return this;
        }

        public Builder withArea(Area area) {
            this.area = Preconditions.checkNotNull(area);
            return this;
        }

        public Builder withDistance(Distance distance) {
            this.distance = distance;
            return this;
        }

        public Builder withDuration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public Builder withComments(String comments) {
            this.comments = Strings.emptyToNull(comments);
            return this;
        }

        public Builder withCompleteChecklist(boolean completeChecklist) {
            this.completeChecklist = completeChecklist;
            return this;
        }

        public Builder withPartySize(int partySize) {
            Preconditions.checkState(partySize > 0);
            this.partySize = partySize;
            return this;
        }

        public Builder withPhotos(Collection<Photo> photos) {
            this.photos = ImmutableList.copyOf(photos);
            return this;
        }

        public VisitInfo build() {
            return new VisitInfo(this);
        }
    }

    public static enum ObservationType {
        INCIDENTAL("Incidental", "incidental", ImmutableSet.of(), ImmutableSet.of(VisitField.DISTANCE, VisitField.DURATION, VisitField.AREA, VisitField.COMPLETE_CHECKLIST), "Casual", "eBird - Casual Observation", "Zuf\u00e4llig", "Ustekabekoa", "Observation informelle", "Casuale", "\u05d0\u05e7\u05e8\u05d0\u05d9\u05ea", "\u5076\u767a\u7684", "Tilfeldig", "Observa\u00e7\u00e3o Casual", "\u0421\u043b\u0443\u0447\u0430\u0439\u043d\u043e\u0435 \u043d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u0435", "Tesad\u00fcfi", "\u0412\u0438\u043f\u0430\u0434\u043a\u043e\u0432\u0435", "\u9644\u5e36\u7d00\u9304", "\u5076\u7136\u8bb0\u5f55"),
        TRAVELING("Traveling", "traveling", ImmutableSet.of(VisitField.START_TIME, VisitField.DURATION, VisitField.DISTANCE, VisitField.PARTY_SIZE), ImmutableSet.of(VisitField.AREA), "Trasa", "Strecke", "Con Desplazamiento", "Mugitzen", "Relev\u00e9 en mouvement ou transect", "Itinerante", "\u05e0\u05d9\u05d9\u05d3\u05ea", "\u79fb\u52d5", "Turbasert", "Percurso", "Contagem de Percurso", "\u041d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u0435 \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u043f\u0435\u0440\u0435\u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f", "Seyyar", "\u041c\u0430\u0440\u0448\u0440\u0443\u0442\u043d\u0435", "\u884c\u9032\u8a08\u6578", "\u884c\u8fdb\u4e2d\u89c2\u9e1f", "eBird - Traveling Count"),
        STATIONARY("Stationary", "stationary", ImmutableSet.of(VisitField.START_TIME, VisitField.DURATION, VisitField.PARTY_SIZE), ImmutableSet.of(VisitField.DISTANCE, VisitField.AREA), "eBird - Stationary Count", "Statick\u00e9", "Station\u00e4r", "Estacionario", "Geldirik", "Relev\u00e9 ponctuel ou stationnaire", "Stazionaria", "\u05e0\u05d9\u05d9\u05d7\u05ea", "\u5b9a\u70b9", "Stasjon\u00e6r", "Estacion\u00e1ria", "Contagem Estacion\u00e1ria", "\u041d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u0435 \u0438\u0437 \u043e\u0434\u043d\u043e\u0439 \u0442\u043e\u0447\u043a\u0438", "Sabit", "\u0422\u043e\u0447\u043a\u043e\u0432\u0435", "\u5b9a\u9ede\u8a08\u6578", "\u5b9a\u70b9\u89c2\u9e1f"),
        HISTORICAL("Historical", "historical", ImmutableSet.of(), ImmutableSet.of(), "Historick\u00e9", "Historisch", "Historikoa", "Historique", "Storico", "\u05d4\u05d9\u05e1\u05d8\u05d5\u05e8\u05d9", "\u904e\u53bb\u306e", "Historisk", "Hist\u00f3rico", "\u0418\u0441\u0442\u043e\u0440\u0438\u044f", "Sand\u0131ktan", "\u0406\u0441\u0442\u043e\u0440\u0438\u0447\u043d\u0435", "\u6b77\u53f2\u8cc7\u6599", "\u5386\u53f2\u8bb0\u5f55"),
        AREA("Area", "area", ImmutableSet.of(VisitField.START_TIME, VisitField.DURATION, VisitField.AREA, VisitField.PARTY_SIZE), ImmutableSet.of(VisitField.DISTANCE), "eBird - Exhaustive Area Count"),
        BANDING("Banding", "banding", ImmutableSet.of(VisitField.START_TIME, VisitField.DURATION, VisitField.PARTY_SIZE), ImmutableSet.of(VisitField.DISTANCE), "PriMig - Pri Mig Banding Protocol", "Pri Mig Banding Protocol", "Banding Protocol"),
        PELAGIC_PROTOCOL("eBird Pelagic Protocol", "pelagic", ImmutableSet.of(VisitField.START_TIME, VisitField.DURATION, VisitField.DISTANCE, VisitField.PARTY_SIZE), ImmutableSet.of(VisitField.AREA), new String[0]),
        NOCTURNAL_BIRDING("Nocturnal Birding", "nocturnal", ImmutableSet.of(VisitField.START_TIME, VisitField.DURATION, VisitField.DISTANCE), ImmutableSet.of(VisitField.AREA), "Nocturnal Count"),
        NOCTURNAL_FLIGHT_CALL_COUNT("Nocturnal Flight Call Count", "flight_call", ImmutableSet.of(VisitField.START_TIME, VisitField.DURATION, VisitField.PARTY_SIZE), ImmutableSet.of(VisitField.AREA, VisitField.DISTANCE), "eBird--Nocturnal Flight Call Count"),
        RANDOM("Random", "random", ImmutableSet.of(VisitField.START_TIME, VisitField.DURATION, VisitField.DISTANCE, VisitField.PARTY_SIZE), ImmutableSet.of(VisitField.AREA), "eBird Random Location Count");

        private final String text;
        private final String id;
        private final ImmutableSet<VisitField> requiredFields;
        private final ImmutableSet<VisitField> hiddenFields;
        private final ImmutableSet<String> otherEBirdNames;
        private static final ImmutableMap<String, ObservationType> ID_MAP;
        private static final ImmutableMap<String, ObservationType> EBIRD_ID_MAP;
        private static final ImmutableMap<String, ObservationType> NAMES_MAP;

        private ObservationType(String text, String id, ImmutableSet<VisitField> requiredFields, ImmutableSet<VisitField> hiddenFields, String ... otherEBirdNames) {
            this.text = text;
            this.id = id;
            Preconditions.checkState(Sets.intersection(requiredFields, hiddenFields).isEmpty());
            this.requiredFields = requiredFields;
            this.hiddenFields = hiddenFields;
            this.otherEBirdNames = ImmutableSet.copyOf(otherEBirdNames);
        }

        private static String normalizeName(String string) {
            if ((string = LETTERS_TO_STRIP_FROM_EBIRD_NAMES.removeFrom(string.toLowerCase())).startsWith("ebird")) {
                string = string.substring(5);
            }
            return string;
        }

        public String toString() {
            return this.text;
        }

        public ImmutableSet<VisitField> getHiddenFields() {
            return this.hiddenFields;
        }

        public ImmutableSet<VisitField> getRequiredFields() {
            return this.requiredFields;
        }

        public String id() {
            return this.id;
        }

        public String eBirdId() {
            return this.id();
        }

        public static ObservationType fromId(String id) {
            return ID_MAP.get(id);
        }

        public static ObservationType fromEBirdId(String ebirdId) {
            return EBIRD_ID_MAP.get(ebirdId);
        }

        public static ObservationType fromName(String name) {
            return NAMES_MAP.get(ObservationType.normalizeName(name));
        }

        static {
            ImmutableMap.Builder<String, ObservationType> builder = ImmutableMap.builder();
            ImmutableMap.Builder<String, ObservationType> ebirdBuilder = ImmutableMap.builder();
            HashMap<String, ObservationType> namesMap = Maps.newHashMap();
            for (ObservationType observationType : ObservationType.values()) {
                builder.put(observationType.id(), observationType);
                ebirdBuilder.put(observationType.eBirdId(), observationType);
                namesMap.put(ObservationType.normalizeName(observationType.toString()), observationType);
                for (String name : observationType.otherEBirdNames) {
                    namesMap.put(ObservationType.normalizeName(name), observationType);
                }
            }
            ID_MAP = builder.build();
            EBIRD_ID_MAP = ebirdBuilder.build();
            NAMES_MAP = ImmutableMap.copyOf(namesMap);
        }
    }

    public static enum VisitField {
        START_TIME,
        DURATION,
        DISTANCE,
        AREA,
        PARTY_SIZE,
        COMPLETE_CHECKLIST;

    }
}

