/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.LocalNames;
import com.scythebill.birdlist.model.util.TaxonNames;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SightingTaxons {
    private SightingTaxons() {
    }

    public static SightingTaxon newSightingTaxon(String singleId) {
        return new SingleSightingTaxon(singleId);
    }

    public static SightingTaxon newSightingTaxonWithSecondarySubspecies(String singleId, String subspeciesId) {
        return new SingleWithSubspeciesSightingTaxon(singleId, subspeciesId);
    }

    public static SightingTaxon newSpTaxon(Iterable<String> taxa) {
        return new SpSightingTaxon(taxa);
    }

    public static SightingTaxon newPossiblySpTaxon(Collection<String> taxa) {
        if (taxa.size() == 1) {
            return SightingTaxons.newSightingTaxon(Iterables.getOnlyElement(taxa));
        }
        return SightingTaxons.newSpTaxon(taxa);
    }

    public static SightingTaxon newHybridTaxon(Iterable<String> taxa) {
        return new HybridSightingTaxon(taxa);
    }

    public static SightingTaxon.Resolved newResolved(Taxon taxon) {
        return new SingleSightingTaxon(taxon.getId()).new SingleSightingTaxon.SingleResolved(taxon);
    }

    public static SightingTaxon.Resolved newSpResolved(Collection<Taxon> taxa) {
        ImmutableSet.Builder ids = ImmutableSet.builder();
        for (Taxon taxon : taxa) {
            ids.add(taxon.getId());
        }
        return new SpSightingTaxon(ids.build()).new SpSightingTaxon.SpResolved(taxa);
    }

    public static SightingTaxon.Resolved newPossiblySpResolved(Collection<Taxon> taxa) {
        if (taxa.size() == 1) {
            return SightingTaxons.newResolved(taxa.iterator().next());
        }
        return SightingTaxons.newSpResolved(taxa);
    }

    static class SingleSightingTaxon
    implements SightingTaxon {
        private final String taxonId;

        public SingleSightingTaxon(String taxonId) {
            this.taxonId = Preconditions.checkNotNull(taxonId);
        }

        @Override
        public SightingTaxon.Type getType() {
            return SightingTaxon.Type.SINGLE;
        }

        @Override
        public String getId() {
            return this.taxonId;
        }

        @Override
        public String getSubIdentifier() {
            throw new IllegalStateException();
        }

        @Override
        public Collection<String> getIds() {
            return ImmutableList.of(this.taxonId);
        }

        @Override
        public boolean shouldBeDisplayedWith(String id) {
            return this.taxonId.equals(id);
        }

        @Override
        public SightingTaxon.Resolved resolve(Taxonomy taxonomy) {
            return taxonomy.resolveInto(this);
        }

        @Override
        public SightingTaxon.Resolved resolveInternal(Taxonomy taxonomy) {
            Taxon taxon = taxonomy.getTaxon(this.getId());
            if (taxon == null) {
                throw new NullPointerException("Could not get taxon for \"" + this.getId() + "\"");
            }
            return new SingleResolved(taxon);
        }

        public int hashCode() {
            return this.taxonId.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SingleSightingTaxon)) {
                return false;
            }
            SingleSightingTaxon that = (SingleSightingTaxon)obj;
            return that.taxonId.equals(this.taxonId);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("taxonId", this.taxonId).toString();
        }

        class SingleResolved
        extends BaseResolved {
            private final Taxon taxon;

            public SingleResolved(Taxon taxon) {
                this.taxon = Preconditions.checkNotNull(taxon);
            }

            @Override
            public SightingTaxon.Type getType() {
                return SightingTaxon.Type.SINGLE;
            }

            @Override
            public Taxon.Type getSmallestTaxonType() {
                return this.taxon.getType();
            }

            @Override
            public Taxon.Type getLargestTaxonType() {
                return this.taxon.getType();
            }

            @Override
            public SightingTaxon getParent() {
                return new SingleSightingTaxon(this.taxon.getParent().getId());
            }

            @Override
            public SightingTaxon getParentOfAtLeastType(Taxon.Type smallestType) {
                Taxon parent = this.taxon;
                while (parent.getType().compareTo(smallestType) < 0) {
                    Preconditions.checkState((parent = parent.getParent()) != null);
                }
                if (parent == this.taxon) {
                    return SingleSightingTaxon.this;
                }
                return SightingTaxons.newSightingTaxon(parent.getId());
            }

            @Override
            public SightingTaxon.Resolved resolveParentOfType(Taxon.Type type) {
                Taxon parent = this.taxon;
                while (parent.getType().compareTo(type) != 0) {
                    Preconditions.checkState((parent = parent.getParent()) != null);
                }
                if (parent == this.taxon) {
                    return this;
                }
                return SightingTaxons.newResolved(parent);
            }

            @Override
            public String getCommonName() {
                return this.localNames().getCommonName(this.taxon);
            }

            @Override
            public String getSimpleCommonName() {
                return this.localNames().getSimpleCommonName(this.taxon);
            }

            @Override
            public boolean hasCommonName() {
                return this.taxon.getCommonName() != null;
            }

            @Override
            public String getName() {
                return this.taxon.getName();
            }

            @Override
            public String getFullName() {
                return TaxonUtils.getFullName(this.taxon);
            }

            @Override
            public Species.Status getTaxonStatus() {
                return TaxonUtils.getTaxonStatus(this.taxon);
            }

            @Override
            public boolean isChildOf(Taxon parent) {
                return TaxonUtils.isChildOf(parent, this.taxon);
            }

            @Override
            public Taxon getTaxon() {
                return this.taxon;
            }

            @Override
            public Taxonomy getTaxonomy() {
                return this.taxon.getTaxonomy();
            }

            @Override
            public Collection<Taxon> getTaxa() {
                return ImmutableSet.of(this.taxon);
            }

            @Override
            public SightingTaxon getSightingTaxon() {
                return SingleSightingTaxon.this;
            }
        }
    }

    static final class SingleWithSubspeciesSightingTaxon
    implements SightingTaxon {
        private final String taxonId;
        private final String subspeciesId;

        public SingleWithSubspeciesSightingTaxon(String taxonId, String subspeciesId) {
            this.taxonId = Preconditions.checkNotNull(taxonId);
            this.subspeciesId = Preconditions.checkNotNull(subspeciesId);
        }

        @Override
        public SightingTaxon.Type getType() {
            return SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES;
        }

        @Override
        public String getId() {
            return this.taxonId;
        }

        @Override
        public String getSubIdentifier() {
            return this.subspeciesId;
        }

        @Override
        public Collection<String> getIds() {
            return ImmutableList.of(this.taxonId);
        }

        @Override
        public boolean shouldBeDisplayedWith(String id) {
            return this.taxonId.equals(id);
        }

        @Override
        public SightingTaxon.Resolved resolve(Taxonomy taxonomy) {
            return taxonomy.resolveInto(this);
        }

        @Override
        public SightingTaxon.Resolved resolveInternal(Taxonomy taxonomy) {
            Taxon taxon = taxonomy.getTaxon(this.getId());
            Taxon subspecies = this.findSubspecies(taxon);
            return new SingleWithSubspeciesResolved(MoreObjects.firstNonNull(subspecies, taxon));
        }

        private Taxon findSubspecies(Taxon taxon) {
            for (Taxon child : taxon.getContents()) {
                if (!child.getName().equals(this.subspeciesId)) continue;
                return child;
            }
            return null;
        }

        public int hashCode() {
            return Objects.hashCode(this.taxonId.hashCode(), this.subspeciesId.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SingleWithSubspeciesSightingTaxon)) {
                return false;
            }
            SingleWithSubspeciesSightingTaxon that = (SingleWithSubspeciesSightingTaxon)obj;
            return that.taxonId.equals(this.taxonId) && that.subspeciesId.equals(this.subspeciesId);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("taxonId", this.taxonId).add("ssp", this.subspeciesId).toString();
        }

        class SingleWithSubspeciesResolved
        extends BaseResolved {
            private final Taxon taxon;

            public SingleWithSubspeciesResolved(Taxon taxon) {
                this.taxon = taxon;
            }

            @Override
            public SightingTaxon.Type getType() {
                return SightingTaxon.Type.SINGLE;
            }

            @Override
            public Taxon.Type getSmallestTaxonType() {
                return this.taxon.getType();
            }

            @Override
            public Taxon.Type getLargestTaxonType() {
                return this.taxon.getType();
            }

            @Override
            public SightingTaxon getParent() {
                return new SingleSightingTaxon(this.taxon.getParent().getId());
            }

            @Override
            public SightingTaxon getParentOfAtLeastType(Taxon.Type smallestType) {
                Taxon parent = this.taxon;
                while (parent.getType().compareTo(smallestType) < 0) {
                    Preconditions.checkState((parent = parent.getParent()) != null);
                }
                if (parent == this.taxon && smallestType == Taxon.Type.subspecies) {
                    return SingleWithSubspeciesSightingTaxon.this;
                }
                return SightingTaxons.newSightingTaxon(parent.getId());
            }

            @Override
            public SightingTaxon.Resolved resolveParentOfType(Taxon.Type type) {
                Taxon parent = this.taxon;
                while (parent.getType().compareTo(type) != 0) {
                    Preconditions.checkState((parent = parent.getParent()) != null);
                }
                if (parent == this.taxon) {
                    return this;
                }
                return SightingTaxons.newResolved(this.taxon);
            }

            @Override
            public String getCommonName() {
                return this.localNames().getCommonName(this.taxon);
            }

            @Override
            public boolean hasCommonName() {
                return this.taxon.getCommonName() != null;
            }

            @Override
            public String getSimpleCommonName() {
                return this.localNames().getSimpleCommonName(this.taxon);
            }

            @Override
            public String getName() {
                return this.taxon.getName();
            }

            @Override
            public String getFullName() {
                return TaxonUtils.getFullName(this.taxon);
            }

            @Override
            public Species.Status getTaxonStatus() {
                return TaxonUtils.getTaxonStatus(this.taxon);
            }

            @Override
            public boolean isChildOf(Taxon parent) {
                return TaxonUtils.isChildOf(parent, this.taxon);
            }

            @Override
            public Taxon getTaxon() {
                return this.taxon;
            }

            @Override
            public Taxonomy getTaxonomy() {
                return this.taxon.getTaxonomy();
            }

            @Override
            public Collection<Taxon> getTaxa() {
                return ImmutableSet.of(this.taxon);
            }

            @Override
            public SightingTaxon getSightingTaxon() {
                return SingleWithSubspeciesSightingTaxon.this;
            }
        }
    }

    static final class SpSightingTaxon
    extends MultipleSightingTaxon {
        private static final Joiner NAME_JOINER = Joiner.on('/');

        public SpSightingTaxon(Iterable<String> taxa) {
            super(taxa);
        }

        @Override
        public SightingTaxon.Type getType() {
            return SightingTaxon.Type.SP;
        }

        @Override
        protected SightingTaxon.Resolved newResolved(List<Taxon> taxa) {
            return new SpResolved(taxa);
        }

        private class SpResolved
        extends MultipleResolved {
            public SpResolved(Iterable<Taxon> resolvedTaxa) {
                super(resolvedTaxa);
            }

            @Override
            public SightingTaxon.Type getType() {
                return SightingTaxon.Type.SP;
            }

            @Override
            public SightingTaxon getSightingTaxon() {
                return SpSightingTaxon.this;
            }

            @Override
            public Species.Status getTaxonStatus() {
                Species.Status status = null;
                for (Taxon taxon : this.getTaxa()) {
                    Species.Status taxonStatus = TaxonUtils.getTaxonStatus(taxon);
                    if (status == null) {
                        status = taxonStatus;
                        continue;
                    }
                    if (status.compareTo(taxonStatus) <= 0) continue;
                    status = taxonStatus;
                }
                return status;
            }

            @Override
            protected SightingTaxon newSightingTaxon(Set<String> ids) {
                return new SpSightingTaxon(ids);
            }

            @Override
            protected SightingTaxon.Resolved newResolved(Set<String> ids, Iterable<Taxon> taxa) {
                return new SpSightingTaxon(ids).new SpResolved(taxa);
            }

            @Override
            protected Joiner nameJoiner() {
                return NAME_JOINER;
            }
        }
    }

    static final class HybridSightingTaxon
    extends MultipleSightingTaxon {
        private static final Joiner NAME_JOINER = Joiner.on(" x ");

        public HybridSightingTaxon(Iterable<String> taxa) {
            super(taxa);
        }

        @Override
        public SightingTaxon.Type getType() {
            return SightingTaxon.Type.HYBRID;
        }

        @Override
        protected SightingTaxon.Resolved newResolved(List<Taxon> taxa) {
            return new HybridResolved(taxa);
        }

        private class HybridResolved
        extends MultipleResolved {
            public HybridResolved(Iterable<Taxon> resolvedTaxa) {
                super(resolvedTaxa);
            }

            @Override
            public SightingTaxon.Type getType() {
                return SightingTaxon.Type.HYBRID;
            }

            @Override
            public SightingTaxon getSightingTaxon() {
                return HybridSightingTaxon.this;
            }

            @Override
            protected SightingTaxon newSightingTaxon(Set<String> ids) {
                return new HybridSightingTaxon(ids);
            }

            @Override
            protected SightingTaxon.Resolved newResolved(Set<String> ids, Iterable<Taxon> taxa) {
                return new HybridSightingTaxon(ids).new HybridResolved(taxa);
            }

            @Override
            protected Joiner nameJoiner() {
                return NAME_JOINER;
            }

            @Override
            public Species.Status getTaxonStatus() {
                return Species.Status.LC;
            }
        }
    }

    static abstract class BaseResolved
    implements SightingTaxon.Resolved {
        BaseResolved() {
        }

        public int hashCode() {
            return this.getSightingTaxon().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SightingTaxon.Resolved)) {
                return false;
            }
            SightingTaxon.Resolved that = (SightingTaxon.Resolved)obj;
            return this.getSightingTaxon().equals(that.getSightingTaxon()) && this.getTaxonomy() == that.getTaxonomy();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("taxon", this.getSightingTaxon()).toString();
        }

        @Override
        public String getPreferredSingleName() {
            return this.localNames().isCommonNamePreferred() ? this.getCommonName() : this.getFullName();
        }

        @Override
        public String getPreferredSingleNameWithoutSpecies() {
            SightingTaxon.Resolved speciesParent;
            String speciesCommonName;
            if (!this.getLargestTaxonType().isAtOrLowerLevelThan(Taxon.Type.group)) {
                return this.getPreferredSingleName();
            }
            String preferredName = this.getPreferredSingleName();
            if (preferredName.startsWith(speciesCommonName = (speciesParent = this.getParentOfAtLeastType(Taxon.Type.species).resolveInternal(this.getTaxonomy())).getCommonName())) {
                return CharMatcher.whitespace().trimLeadingFrom(preferredName.substring(speciesCommonName.length()));
            }
            String speciesSciName = speciesParent.getFullName();
            if (preferredName.startsWith(speciesSciName)) {
                return CharMatcher.whitespace().trimLeadingFrom(preferredName.substring(speciesSciName.length()));
            }
            return preferredName;
        }

        @Override
        public SightingTaxon getSightingTaxonInBaseTaxonomy() {
            SightingTaxon sightingTaxon = this.getSightingTaxon();
            Taxonomy taxonomy = this.getTaxa().iterator().next().getTaxonomy();
            if (taxonomy instanceof MappedTaxonomy) {
                MappedTaxonomy mappedTaxonomy = (MappedTaxonomy)taxonomy;
                sightingTaxon = mappedTaxonomy.getMapping(sightingTaxon);
            }
            return sightingTaxon;
        }

        protected LocalNames localNames() {
            return this.getTaxonomy().getLocalNames();
        }
    }

    static abstract class MultipleResolved
    extends BaseResolved {
        private ImmutableSortedSet<Taxon> resolvedTaxa;

        public MultipleResolved(Iterable<Taxon> resolvedTaxa) {
            this.resolvedTaxa = ImmutableSortedSet.copyOf(TaxonUtils.ORDERING, resolvedTaxa);
        }

        protected abstract SightingTaxon newSightingTaxon(Set<String> var1);

        protected abstract SightingTaxon.Resolved newResolved(Set<String> var1, Iterable<Taxon> var2);

        protected abstract Joiner nameJoiner();

        @Override
        public SightingTaxon getParent() {
            Taxon.Type currentLevel = this.getLargestTaxonType();
            ImmutableSet.Builder parents = ImmutableSet.builder();
            for (Taxon taxon : this.resolvedTaxa) {
                Taxon taxonAtLevel = TaxonUtils.getParentOfTypeOrNull(taxon, currentLevel);
                parents.add(taxonAtLevel.getParent().getId());
            }
            ImmutableCollection built = parents.build();
            if (built.size() == 1) {
                return new SingleSightingTaxon((String)Iterables.getOnlyElement(built));
            }
            return this.newSightingTaxon((Set<String>)((Object)built));
        }

        @Override
        public SightingTaxon getParentOfAtLeastType(Taxon.Type smallestType) {
            ImmutableSet.Builder parents = ImmutableSet.builder();
            for (Taxon taxon : this.resolvedTaxa) {
                parents.add(TaxonUtils.getParentOfAtLeastType(taxon, smallestType).getId());
            }
            ImmutableCollection built = parents.build();
            if (built.size() == 1) {
                return new SingleSightingTaxon((String)Iterables.getOnlyElement(built));
            }
            return this.newSightingTaxon((Set<String>)((Object)built));
        }

        @Override
        public SightingTaxon.Resolved resolveParentOfType(Taxon.Type type) {
            if (type == this.getLargestTaxonType() && type == this.getSmallestTaxonType()) {
                return this;
            }
            ImmutableSet.Builder parents = ImmutableSet.builder();
            for (Taxon taxon : this.resolvedTaxa) {
                parents.add(TaxonUtils.getParentOfType(taxon, type));
            }
            ImmutableCollection built = parents.build();
            if (built.size() == 1) {
                return SightingTaxons.newResolved((Taxon)Iterables.getOnlyElement(built));
            }
            ImmutableSet.Builder ids = ImmutableSet.builder();
            for (Taxon taxon : built) {
                ids.add(taxon.getId());
            }
            return this.newResolved((Set<String>)((Object)ids.build()), built);
        }

        @Override
        public Taxon getTaxon() {
            throw new IllegalStateException("Not a single taxon");
        }

        @Override
        public Collection<Taxon> getTaxa() {
            return this.resolvedTaxa;
        }

        @Override
        public Taxonomy getTaxonomy() {
            return ((Taxon)this.resolvedTaxa.iterator().next()).getTaxonomy();
        }

        @Override
        public Taxon.Type getSmallestTaxonType() {
            Taxon.Type smallestType = Taxon.Type.classTaxon;
            for (Taxon taxon : this.resolvedTaxa) {
                Taxon.Type type = taxon.getType();
                if (type.compareTo(smallestType) >= 0) continue;
                smallestType = type;
            }
            return smallestType;
        }

        @Override
        public Taxon.Type getLargestTaxonType() {
            Taxon.Type largestType = Taxon.Type.subspecies;
            for (Taxon taxon : this.resolvedTaxa) {
                Taxon.Type type = taxon.getType();
                if (type.compareTo(largestType) <= 0) continue;
                largestType = type;
            }
            return largestType;
        }

        @Override
        public String getCommonName() {
            ArrayList<String> names = Lists.newArrayList();
            for (Taxon taxon : this.resolvedTaxa) {
                names.add(this.localNames().getCommonName(taxon));
            }
            switch (this.getLargestTaxonType()) {
                case species: {
                    return TaxonNames.joinFromEnd(names, this.nameJoiner());
                }
                case group: 
                case subspecies: {
                    return TaxonNames.joinFromStart(names, this.nameJoiner());
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String getSimpleCommonName() {
            ArrayList<String> names = Lists.newArrayList();
            for (Taxon taxon : this.resolvedTaxa) {
                String simpleCommonName = this.localNames().getSimpleCommonName(taxon);
                if (!names.isEmpty() && simpleCommonName.equals(names.get(names.size() - 1))) continue;
                names.add(simpleCommonName);
            }
            switch (this.getLargestTaxonType()) {
                case species: {
                    return TaxonNames.joinFromEnd(names, this.nameJoiner());
                }
                case group: 
                case subspecies: {
                    return TaxonNames.joinFromStart(names, this.nameJoiner());
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public boolean hasCommonName() {
            for (Taxon taxon : this.resolvedTaxa) {
                if (taxon.getCommonName() != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getFullName() {
            ArrayList<String> names = Lists.newArrayList();
            for (Taxon taxon : this.resolvedTaxa) {
                names.add(TaxonUtils.getFullName(taxon));
            }
            return TaxonNames.joinFromStart(names, this.nameJoiner());
        }

        @Override
        public String getName() {
            ArrayList<String> names = Lists.newArrayList();
            for (Taxon taxon : this.resolvedTaxa) {
                names.add(taxon.getName());
            }
            return this.nameJoiner().join(names);
        }

        @Override
        public boolean isChildOf(Taxon parent) {
            for (Taxon taxon : this.resolvedTaxa) {
                if (TaxonUtils.isChildOf(parent, taxon)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.resolvedTaxa.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            MultipleResolved that = (MultipleResolved)obj;
            return that.resolvedTaxa.equals(this.resolvedTaxa);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).add("resolvedTaxa", this.resolvedTaxa).toString();
        }
    }

    static abstract class MultipleSightingTaxon
    implements SightingTaxon {
        private final ImmutableSortedSet<String> taxa;

        public MultipleSightingTaxon(Iterable<String> taxa) {
            this.taxa = ImmutableSortedSet.copyOf(taxa);
            if (this.taxa.size() < 2) {
                throw new IllegalStateException("Taxa list too small for multiple");
            }
        }

        @Override
        public String getId() {
            throw new IllegalStateException("Multiple taxa on " + this + ", may not call getId().");
        }

        @Override
        public String getSubIdentifier() {
            throw new IllegalStateException();
        }

        @Override
        public Collection<String> getIds() {
            return this.taxa;
        }

        @Override
        public boolean shouldBeDisplayedWith(String id) {
            return this.taxa.contains(id);
        }

        @Override
        public SightingTaxon.Resolved resolve(Taxonomy taxonomy) {
            return taxonomy.resolveInto(this);
        }

        @Override
        public SightingTaxon.Resolved resolveInternal(Taxonomy taxonomy) {
            ArrayList<Taxon> resolvedTaxa = Lists.newArrayListWithCapacity(this.taxa.size());
            for (String id : this.taxa) {
                Taxon taxon = taxonomy.getTaxon(id);
                if (taxon == null) {
                    throw new IllegalStateException("Could not resolve " + id + " in " + taxonomy.getName());
                }
                resolvedTaxa.add(taxon);
            }
            return this.newResolved(resolvedTaxa);
        }

        protected abstract SightingTaxon.Resolved newResolved(List<Taxon> var1);

        public int hashCode() {
            return this.taxa.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            MultipleSightingTaxon that = (MultipleSightingTaxon)obj;
            return that.taxa.equals(this.taxa);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("taxa", this.taxa).toString();
        }
    }
}

