/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.util.Collection;

public interface SightingTaxon {
    public Type getType();

    public String getId();

    public String getSubIdentifier();

    public Collection<String> getIds();

    public boolean shouldBeDisplayedWith(String var1);

    public Resolved resolve(Taxonomy var1);

    public Resolved resolveInternal(Taxonomy var1);

    public static interface Resolved {
        public Type getType();

        public SightingTaxon getParentOfAtLeastType(Taxon.Type var1);

        public Resolved resolveParentOfType(Taxon.Type var1);

        public SightingTaxon getParent();

        public Taxon getTaxon();

        public Collection<Taxon> getTaxa();

        public Taxon.Type getSmallestTaxonType();

        public Taxon.Type getLargestTaxonType();

        public String getCommonName();

        public boolean hasCommonName();

        public String getSimpleCommonName();

        public String getName();

        public String getFullName();

        public Species.Status getTaxonStatus();

        public boolean isChildOf(Taxon var1);

        public SightingTaxon getSightingTaxon();

        public SightingTaxon getSightingTaxonInBaseTaxonomy();

        public Taxonomy getTaxonomy();

        public String getPreferredSingleName();

        public String getPreferredSingleNameWithoutSpecies();
    }

    public static enum Type {
        SINGLE,
        SP,
        HYBRID,
        SINGLE_WITH_SECONDARY_SUBSPECIES;

    }
}

