/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.sighting.ApproximateNumber;
import com.scythebill.birdlist.model.sighting.Photo;
import com.scythebill.birdlist.model.user.User;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class SightingInfo
implements Cloneable {
    private String description;
    private ApproximateNumber number;
    private boolean female;
    private boolean male;
    private boolean adult;
    private boolean immature;
    private boolean heardOnly;
    private SightingStatus sightingStatus = SightingStatus.NONE;
    private boolean photographed;
    private BreedingBirdCode breedingBirdCode = BreedingBirdCode.NONE;
    private List<Photo> photos;
    private ImmutableSet<User> users;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isFemale() {
        return this.female;
    }

    public void setFemale(boolean female) {
        this.female = female;
    }

    public boolean isHeardOnly() {
        return this.heardOnly;
    }

    public void setHeardOnly(boolean heardOnly) {
        this.heardOnly = heardOnly;
    }

    public boolean isImmature() {
        return this.immature;
    }

    public void setImmature(boolean immature) {
        this.immature = immature;
    }

    public boolean isAdult() {
        return this.adult;
    }

    public void setAdult(boolean adult) {
        this.adult = adult;
    }

    public boolean isMale() {
        return this.male;
    }

    public void setMale(boolean male) {
        this.male = male;
    }

    public ApproximateNumber getNumber() {
        return this.number;
    }

    public SightingInfo setNumber(ApproximateNumber number) {
        this.number = number;
        return this;
    }

    public SightingStatus getSightingStatus() {
        return this.sightingStatus;
    }

    public void setSightingStatus(SightingStatus sightingStatus) {
        this.sightingStatus = sightingStatus;
    }

    public BreedingBirdCode getBreedingBirdCode() {
        return this.breedingBirdCode;
    }

    public void setBreedingBirdCode(BreedingBirdCode breedingBirdCode) {
        this.breedingBirdCode = breedingBirdCode;
    }

    public boolean isPhotographed() {
        return this.photographed;
    }

    public void setPhotographed(boolean photographed) {
        this.photographed = photographed;
    }

    public List<Photo> getPhotos() {
        if (this.photos == null) {
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(this.photos);
    }

    public void setPhotos(List<Photo> newPhotos) {
        this.photos = newPhotos.isEmpty() ? null : Lists.newArrayList(newPhotos);
    }

    public ImmutableSet<User> getUsers() {
        if (this.users == null) {
            return ImmutableSet.of();
        }
        return this.users;
    }

    public void setUsers(Collection<User> collection) {
        this.users = collection.isEmpty() ? null : ImmutableSet.copyOf(collection);
    }

    public SightingInfo clone() {
        try {
            SightingInfo cloned = (SightingInfo)super.clone();
            if (this.photos != null) {
                cloned.photos = Lists.newArrayList(this.photos);
            }
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void mergeWith(SightingInfo that) {
        this.adult = this.adult || that.adult;
        this.female = this.female || that.female;
        this.male = this.male || that.male;
        this.immature = this.immature || that.immature;
        boolean bl = this.photographed = this.photographed || that.photographed;
        if (that.photos != null) {
            if (this.photos == null) {
                this.photos = Lists.newArrayList();
            }
            this.photos.addAll(that.photos);
        }
        boolean bl2 = this.heardOnly = this.heardOnly && that.heardOnly;
        if (this.breedingBirdCode == BreedingBirdCode.NONE) {
            this.breedingBirdCode = that.breedingBirdCode;
        }
        if (this.number != null && that.number != null) {
            this.number = this.number.plus(that.number);
        }
        if (this.sightingStatus.compareTo(that.sightingStatus) > 0) {
            this.sightingStatus = that.sightingStatus;
        }
        if (this.description == null) {
            this.description = that.description;
        } else if (that.description != null) {
            this.description = this.description + "\n" + that.description;
        }
        if (this.users == null || this.users.isEmpty()) {
            this.users = that.users;
        } else if (that.users != null) {
            this.users = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.users)).addAll(that.users)).build();
        }
    }

    public static enum SightingStatus {
        NONE("none", ""),
        RECORD_NOT_ACCEPTED("notAccepted", "not accepted"),
        BETTER_VIEW_DESIRED("bvd", "better view desired"),
        INTRODUCED("intro", "introduced"),
        INTRODUCED_NOT_ESTABLISHED("notEstablished", "not established"),
        RESTRAINED("restrained", "restrained"),
        DOMESTIC("domestic", "domestic"),
        ID_UNCERTAIN("idUncertain", "uncertain"),
        UNSATISFACTORY_VIEWS("unsatisfactoryViews", "unsatisfactory views"),
        NOT_BY_ME("notByMe", "not by me"),
        DEAD("dead", "dead"),
        SIGNS("signs", "signs");

        private final String id;
        private final String export;
        private static final ImmutableMap<String, SightingStatus> byId;
        private static final ImmutableMap<String, SightingStatus> byExport;

        public static SightingStatus forId(String id) {
            return byId.get(id);
        }

        public static SightingStatus forExportText(String exportText) {
            return byExport.get(exportText);
        }

        private SightingStatus(String id, String export) {
            this.id = id;
            this.export = export;
        }

        public String getId() {
            return this.id;
        }

        public String getExportText() {
            return this.export;
        }

        static {
            ImmutableMap.Builder<String, SightingStatus> builder = ImmutableMap.builder();
            ImmutableMap.Builder<String, SightingStatus> exportBuilder = ImmutableMap.builder();
            for (SightingStatus status : SightingStatus.values()) {
                builder.put(status.getId(), status);
                exportBuilder.put(status.getExportText(), status);
            }
            byId = builder.build();
            byExport = exportBuilder.build();
        }
    }

    public static enum BreedingBirdCode {
        NONE("", ""),
        NEST_WITH_YOUNG("NY", "16"),
        NEST_WITH_EGGS("NE", "15"),
        CARRYING_FECAL_SAC("CS", "14"),
        FEEDING_YOUNG("FY", "12"),
        CARRYING_FOOD("CF", "14"),
        RECENTLY_FLEDGED("FL", "12"),
        OCCUPIED_NEST("ON", "13"),
        USED_NEST("UN", "11"),
        DISTRACTION_DISPLAY("DD", "10"),
        NEST_BUILDING("NB", "09"),
        CARRYING_NESTING_MATERIAL("CN", "09"),
        PHYSIOLOGICAL_EVIDENCE("PE", ""),
        WOODPECKER_WREN_NEST_BUILDING("B", "09"),
        AGITATED_BEHAVIOR("A", "07"),
        VISITING_PROBABLE_NEST_SITE("N", "06"),
        COURTSHIP_DISPLAY_OR_COPULATION("C", "05"),
        TERRITORIAL_DEFENSE("T", "04"),
        PAIR_IN_SUITABLE_HABITAT("P", "03"),
        MULTIPLE_SINGING_BIRDS("M", "02"),
        SINGING_BIRD_7_DAYS("S7", "02"),
        SINGING_BIRD("S", "02"),
        IN_APPROPRIATE_HABITAT("H", "01"),
        FLYOVER("F", "00");

        private final String id;
        private final String birdTrackId;
        private static final ImmutableMap<String, BreedingBirdCode> byId;

        public static BreedingBirdCode forId(String id) {
            return byId.get(id);
        }

        private BreedingBirdCode(String id, String birdTrackId) {
            this.id = id;
            this.birdTrackId = birdTrackId;
        }

        public String getId() {
            return this.id;
        }

        public String getBirdTrackId() {
            return this.birdTrackId;
        }

        static {
            ImmutableMap.Builder<String, BreedingBirdCode> builder = ImmutableMap.builder();
            for (BreedingBirdCode status : BreedingBirdCode.values()) {
                if (status == NONE) continue;
                builder.put(status.getId(), status);
            }
            byId = builder.build();
        }
    }
}

