/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class Sighting {
    private final SightingTaxon taxon;
    private ReadablePartial date;
    private String locationId;
    private SightingInfo sightingInfo;
    private Trip trip;
    private Taxonomy taxonomy;
    private LocalTime time;

    public static Builder newBuilder() {
        return new Builder();
    }

    private Sighting(SightingTaxon sightingTaxon, Taxonomy taxonomy) {
        this.taxon = Preconditions.checkNotNull(sightingTaxon, "Null taxon");
        this.taxonomy = Preconditions.checkNotNull(taxonomy, "Null taxonomy");
    }

    public Builder asBuilder() {
        return new Builder(this);
    }

    public String getLocationId() {
        return this.locationId;
    }

    public Taxonomy getTaxonomy() {
        return this.taxonomy;
    }

    public SightingTaxon getTaxon() {
        return this.taxon;
    }

    public ReadablePartial getStoredDateAsPartial() {
        return this.date;
    }

    public LocalTime getStoredTimeAsPartial() {
        return this.time;
    }

    public ReadablePartial getSingleDateAsPartial() {
        if (this.date != null) {
            return this.date;
        }
        if (this.trip != null && this.trip.startDate().equals(this.trip.endDate())) {
            return this.trip.startDate();
        }
        return null;
    }

    public ReadablePartial getStartDateAsPartial() {
        if (this.date != null) {
            return this.date;
        }
        if (this.trip != null) {
            return this.trip.startDate();
        }
        return null;
    }

    public ReadablePartial getEndDateAsPartial() {
        if (this.date != null) {
            return this.date;
        }
        if (this.trip != null) {
            return this.trip.endDate();
        }
        return null;
    }

    public Trip getTrip() {
        return this.trip;
    }

    public boolean hasSightingInfo() {
        return this.sightingInfo != null;
    }

    public SightingInfo getSightingInfo() {
        if (this.sightingInfo == null) {
            this.sightingInfo = new SightingInfo();
        }
        return this.sightingInfo;
    }

    public void setSightingInfo(SightingInfo sightingInfo) {
        this.sightingInfo = sightingInfo;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("taxon", this.taxon).add("where", this.locationId).addValue(this.date).addValue(this.time).addValue(this.trip).addValue(this.sightingInfo).toString();
    }

    public Sighting mergeWith(Sighting newSighting) {
        Builder builder = this.asBuilder();
        builder.getSightingInfo().mergeWith(newSighting.getSightingInfo());
        return builder.build();
    }

    public static class Builder {
        private ReadablePartial date;
        private LocalTime time;
        private String locationId;
        private Trip trip;
        private SightingTaxon taxon;
        private SightingInfo sightingInfo;
        private Taxonomy taxonomy;
        private Location location;

        private Builder() {
        }

        private Builder(Sighting baseSighting) {
            this.date = baseSighting.date;
            this.time = baseSighting.time;
            this.locationId = baseSighting.locationId;
            this.taxon = baseSighting.taxon;
            this.taxonomy = baseSighting.taxonomy;
            this.trip = baseSighting.trip;
            if (baseSighting.sightingInfo != null) {
                this.sightingInfo = baseSighting.sightingInfo.clone();
            }
        }

        public Builder setTaxonomy(Taxonomy taxonomy) {
            Preconditions.checkArgument(!(taxonomy instanceof MappedTaxonomy), "Mapped taxonomy may not be attached to Sighting");
            this.taxonomy = taxonomy;
            return this;
        }

        public Builder setDate(ReadablePartial date) {
            this.date = date;
            if (date != null) {
                this.trip = null;
            }
            return this;
        }

        public ReadablePartial getDate() {
            return this.date;
        }

        public Builder setTime(LocalTime time) {
            this.time = time;
            return this;
        }

        public Builder setLocation(Location location) {
            this.locationId = Preconditions.checkNotNull(location.getId());
            this.location = location;
            return this;
        }

        public String getLocationId() {
            return this.locationId;
        }

        public Location getLocation() {
            return this.location;
        }

        public Builder setTaxon(Taxon taxon) {
            this.taxon = taxon.toBaseSightingTaxon();
            this.taxonomy = TaxonUtils.getBaseTaxonomy(taxon.getTaxonomy());
            return this;
        }

        public Builder setTaxon(SightingTaxon sightingTaxon) {
            this.taxon = sightingTaxon;
            return this;
        }

        public Builder setTaxon(SightingTaxon.Resolved resolved) {
            this.taxon = resolved.getSightingTaxonInBaseTaxonomy();
            this.taxonomy = TaxonUtils.getBaseTaxonomy(resolved.getTaxonomy());
            return this;
        }

        public SightingTaxon getTaxon() {
            return this.taxon;
        }

        public SightingInfo getSightingInfo() {
            if (this.sightingInfo == null) {
                this.sightingInfo = new SightingInfo();
            }
            return this.sightingInfo;
        }

        public Builder setSightingInfo(SightingInfo sightingInfo) {
            this.sightingInfo = sightingInfo;
            return this;
        }

        public Trip getTrip() {
            return this.trip;
        }

        public Builder setTrip(Trip trip) {
            this.trip = trip;
            return this;
        }

        public Sighting build() {
            Sighting sighting = new Sighting(this.taxon, this.taxonomy);
            sighting.locationId = this.locationId;
            sighting.sightingInfo = this.sightingInfo;
            sighting.date = this.date;
            sighting.time = this.time;
            sighting.trip = this.trip;
            return sighting;
        }
    }
}

