/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvException;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class ReportSets {
    public static final String VERSION_FORMAT_CURRENT = "19.0.0";
    private static final String WORLD_REGIONS_PREFIX = "";
    private static final String WORLD_COUNTRIES_PREFIX = "ct";
    private static final String US_STATES_PREFIX = "usst";

    public static ReportSet newReportSet(Taxonomy taxonomy) {
        LocationSet newLocations = ReportSets.newLocations();
        Trips trips = new Trips(newLocations);
        ReportSet reportSet = new ReportSet(newLocations, trips, Lists.newArrayList(), taxonomy);
        reportSet.setLoadedVersion(VERSION_FORMAT_CURRENT);
        return reportSet;
    }

    public static LocationSet newLocations() {
        HashMap<String, Location> locationsMap = Maps.newHashMap();
        LocationSet.Builder builder = new LocationSet.Builder();
        LocationSet locations = builder.build();
        for (String string : ImmutableSet.of("North America", "South America", "Eurasia", "Africa", "Australasia", "Pacific Ocean", new String[]{"Indian Ocean", "Atlantic Ocean", "Arctic Ocean", "South Polar Region"})) {
            Location location = Location.builder().setName(string).setType(Location.Type.region).setBuiltInPrefix(WORLD_REGIONS_PREFIX).build();
            locations.addLocation(location);
            locationsMap.put(string, location);
        }
        Location eurasia = Preconditions.checkNotNull((Location)locationsMap.get("Eurasia"));
        for (String string : ImmutableSet.of("Europe", "Asia")) {
            Location location = Location.builder().setName(string).setType(Location.Type.region).setParent(eurasia).setBuiltInPrefix(WORLD_REGIONS_PREFIX).build();
            locations.addLocation(location);
            locationsMap.put(string, location);
        }
        Location location = Preconditions.checkNotNull((Location)locationsMap.get("North America"));
        for (String string : ImmutableSet.of("West Indies", "Central America")) {
            Location location2 = Location.builder().setName(string).setType(Location.Type.region).setBuiltInPrefix(WORLD_REGIONS_PREFIX).setParent(location).build();
            locations.addLocation(location2);
            locationsMap.put(string, location2);
        }
        HashMap<String, Location> hashMap = Maps.newHashMap();
        for (String[] line : ReportSets.csvContents("countries.csv")) {
            String country = line[0];
            Location parent = Preconditions.checkNotNull((Location)locationsMap.get(line[1]));
            Location.Type type = Location.Type.country;
            if (line.length >= 4 && line[3].equalsIgnoreCase("State")) {
                type = Location.Type.state;
            }
            Location.Builder countryBuilder = Location.builder().setName(country).setType(type).setBuiltInPrefix(WORLD_COUNTRIES_PREFIX).setParent(parent);
            Preconditions.checkArgument(line.length >= 2);
            Preconditions.checkArgument(!Strings.isNullOrEmpty(line[2]));
            countryBuilder.setEbirdCode(line[2]);
            Location location3 = countryBuilder.build();
            locations.addLocation(location3);
            if (!"United States".equals(country)) continue;
            hashMap.put(line[1], location3);
        }
        for (String[] line : ReportSets.csvContents("us-states.csv")) {
            String state = line[0];
            String usRegion = line[1];
            String ebirdCode = line[2];
            String type = line.length >= 4 ? line[3] : null;
            Location parent = Preconditions.checkNotNull((Location)hashMap.get(usRegion));
            Location location4 = Location.builder().setName(state).setParent(parent).setEbirdCode(ebirdCode).setType("country".equals(type) ? Location.Type.country : Location.Type.state).setBuiltInPrefix(US_STATES_PREFIX).build();
            locations.addLocation(location4);
        }
        Location location5 = (Location)locationsMap.get("Europe");
        Location uk = location5.getContent("United Kingdom");
        PredefinedLocations predefinedLocations = PredefinedLocations.loadAndParse();
        predefinedLocations.mergeInto(locations, uk);
        return locations;
    }

    private static Iterable<String[]> csvContents(String csvFile) {
        Iterable<String[]> iterable;
        URL url = Resources.getResource(ReportSets.class, csvFile);
        CSVReader csvReader = new CSVReader(Resources.asCharSource(url, StandardCharsets.UTF_8).openBufferedStream());
        try {
            iterable = Iterables.skip(csvReader.readAll(), 1);
        }
        catch (Throwable throwable) {
            try {
                try {
                    csvReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (CsvException | IOException e) {
                throw new RuntimeException(e);
            }
        }
        csvReader.close();
        return iterable;
    }
}

