/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public final class ReportSetMutator {
    private final ReportSet reportSet;
    private final List<Sighting> added = Lists.newArrayList();
    private final List<Sighting> removed = Lists.newArrayList();
    private boolean mutated = false;
    private Optional<String> location = Optional.absent();
    private Optional<Optional<ReadablePartial>> date = Optional.absent();
    private Optional<Optional<LocalTime>> startTime = Optional.absent();

    ReportSetMutator(ReportSet reportSet) {
        this.reportSet = reportSet;
    }

    public ReportSetMutator adding(Collection<Sighting> sightingsToAdd) {
        Preconditions.checkState(!this.mutated);
        this.added.addAll(sightingsToAdd);
        return this;
    }

    public ReportSetMutator removing(Collection<Sighting> sightingsToRemove) {
        Preconditions.checkState(!this.mutated);
        this.removed.addAll(sightingsToRemove);
        return this;
    }

    public ReportSetMutator withChangedLocation(String locationId) {
        Preconditions.checkState(!this.mutated);
        this.location = Optional.of(locationId);
        return this;
    }

    public ReportSetMutator withChangedDate(ReadablePartial date) {
        Preconditions.checkState(!this.mutated);
        this.date = Optional.of(date == null ? Optional.absent() : Optional.of(date));
        return this;
    }

    public ReportSetMutator withChangedStartTime(Optional<LocalTime> startTime) {
        Preconditions.checkState(!this.mutated);
        this.startTime = Optional.of(startTime);
        return this;
    }

    public void mutate() {
        VisitInfoKey visitInfoKey;
        this.mutated = true;
        boolean visitInfoKeysChanged = this.location.isPresent() || this.date.isPresent() || this.startTime.isPresent();
        LinkedHashMap<VisitInfoKey, VisitInfo> existingVisitInfo = null;
        if (visitInfoKeysChanged) {
            Preconditions.checkState(!this.removed.isEmpty(), "Mutation specifies visit info key changes, but didn't remove anything?");
            Preconditions.checkState(!this.added.isEmpty(), "Mutation specifies visit info key changes, but didn't add anything?");
            for (Sighting sighting : this.added) {
                if (this.location.isPresent()) {
                    Preconditions.checkArgument(Objects.equal(this.location.get(), sighting.getLocationId()));
                }
                if (this.date.isPresent()) {
                    ReadablePartial sightingDate = sighting.getStoredDateAsPartial();
                    if (this.date.get().isPresent()) {
                        Preconditions.checkArgument(sightingDate != null, "No date stored at all");
                        ReadablePartial updatedDate = this.date.get().get();
                        if (updatedDate.isSupported(DateTimeFieldType.year())) {
                            Preconditions.checkArgument(sightingDate.isSupported(DateTimeFieldType.year()), "Year not stored");
                            Preconditions.checkArgument(sightingDate.get(DateTimeFieldType.year()) == updatedDate.get(DateTimeFieldType.year()), "Year not equal");
                        }
                        if (updatedDate.isSupported(DateTimeFieldType.monthOfYear())) {
                            Preconditions.checkArgument(sightingDate.isSupported(DateTimeFieldType.monthOfYear()), "Month not stored");
                            Preconditions.checkArgument(sightingDate.get(DateTimeFieldType.monthOfYear()) == updatedDate.get(DateTimeFieldType.monthOfYear()), "Month not equal");
                        }
                        if (updatedDate.isSupported(DateTimeFieldType.dayOfMonth())) {
                            Preconditions.checkArgument(sightingDate.isSupported(DateTimeFieldType.dayOfMonth()), "Day not stored");
                            Preconditions.checkArgument(sightingDate.get(DateTimeFieldType.dayOfMonth()) == updatedDate.get(DateTimeFieldType.dayOfMonth()), "Day not equal");
                        }
                    } else {
                        Preconditions.checkArgument(sightingDate == null, "Date is stored, should be removed");
                    }
                }
                if (!this.startTime.isPresent()) continue;
                Optional<LocalTime> value = this.startTime.get();
                if (value.isPresent()) {
                    Preconditions.checkArgument(Objects.equal(value.get(), sighting.getStoredTimeAsPartial()));
                    continue;
                }
                Preconditions.checkArgument(sighting.getStoredTimeAsPartial() == null);
            }
        }
        if (visitInfoKeysChanged || this.added.isEmpty()) {
            existingVisitInfo = Maps.newLinkedHashMap();
            for (Sighting sighting : this.removed) {
                VisitInfo visitInfo;
                visitInfoKey = VisitInfoKey.forSighting(sighting);
                if (visitInfoKey == null || existingVisitInfo.containsKey(visitInfoKey) || (visitInfo = this.reportSet.getVisitInfo(visitInfoKey)) == null) continue;
                existingVisitInfo.put(visitInfoKey, visitInfo);
            }
        }
        this.reportSet.removeSightings(this.removed);
        this.reportSet.addSightings(this.added);
        if (existingVisitInfo != null && !existingVisitInfo.isEmpty()) {
            for (Sighting sighting : this.reportSet.getSightings()) {
                visitInfoKey = VisitInfoKey.forSighting(sighting);
                if (visitInfoKey == null || !existingVisitInfo.containsKey(visitInfoKey)) continue;
                existingVisitInfo.remove(visitInfoKey);
            }
            if (!existingVisitInfo.isEmpty()) {
                if (this.added.isEmpty()) {
                    for (VisitInfoKey visitInfoKey2 : existingVisitInfo.keySet()) {
                        this.reportSet.removeVisitInfo(visitInfoKey2);
                    }
                } else {
                    for (Map.Entry entry : existingVisitInfo.entrySet()) {
                        VisitInfoKey oldVisitInfoKey = (VisitInfoKey)entry.getKey();
                        if (!this.date.isPresent() || this.date.get().isPresent()) {
                            VisitInfoKey newVisitInfoKey = oldVisitInfoKey;
                            if (this.location.isPresent()) {
                                newVisitInfoKey = newVisitInfoKey.withLocationId(this.location.get());
                            }
                            if (this.date.isPresent()) {
                                newVisitInfoKey = newVisitInfoKey.withDate(this.date.get().get());
                            }
                            if (this.startTime.isPresent()) {
                                newVisitInfoKey = newVisitInfoKey.withStartTime(this.startTime.get());
                            }
                            Preconditions.checkState(!oldVisitInfoKey.equals(newVisitInfoKey));
                            VisitInfo visitInfoAlreadyAtNewKey = this.reportSet.getVisitInfo(newVisitInfoKey);
                            if (visitInfoAlreadyAtNewKey == null) {
                                this.reportSet.putVisitInfo(newVisitInfoKey, (VisitInfo)entry.getValue());
                            } else {
                                VisitInfo soonToBeLostVistInfo = (VisitInfo)entry.getValue();
                                if (soonToBeLostVistInfo.comments().isPresent()) {
                                    Object combinedComments = !visitInfoAlreadyAtNewKey.comments().isPresent() ? soonToBeLostVistInfo.comments().get() : visitInfoAlreadyAtNewKey.comments().get() + "\n" + soonToBeLostVistInfo.comments().get();
                                    this.reportSet.putVisitInfo(newVisitInfoKey, visitInfoAlreadyAtNewKey.asBuilder().withComments((String)combinedComments).build());
                                }
                            }
                        }
                        this.reportSet.removeVisitInfo(oldVisitInfoKey);
                    }
                }
            }
        }
        this.reportSet.markDirty();
    }
}

